/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="CustomLevel", category="Core", printObject=true)
public final class CustomLevelConfig {
    private final String levelName;
    private final int intLevel;

    private CustomLevelConfig(String string, int n2) {
        this.levelName = Objects.requireNonNull(string, "levelName is null");
        this.intLevel = n2;
    }

    @PluginFactory
    public static CustomLevelConfig createLevel(@PluginAttribute(value="name") String string, @PluginAttribute(value="intLevel") int n2) {
        StatusLogger.getLogger().debug("Creating CustomLevel(name='{}', intValue={})", (Object)string, (Object)n2);
        Level.forName(string, n2);
        return new CustomLevelConfig(string, n2);
    }

    public String getLevelName() {
        return this.levelName;
    }

    public int getIntLevel() {
        return this.intLevel;
    }

    public int hashCode() {
        return this.intLevel ^ this.levelName.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CustomLevelConfig)) {
            return false;
        }
        CustomLevelConfig customLevelConfig = (CustomLevelConfig)object;
        return this.intLevel == customLevelConfig.intLevel && this.levelName.equals(customLevelConfig.levelName);
    }

    public String toString() {
        return "CustomLevel[name=" + this.levelName + ", intLevel=" + this.intLevel + "]";
    }
}

