/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.ConfigurationScheduler$CronRunnable;
import org.apache.logging.log4j.core.config.CronScheduledFuture;
import org.apache.logging.log4j.core.util.CronExpression;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.status.StatusLogger;

public class ConfigurationScheduler
extends AbstractLifeCycle {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String SIMPLE_NAME = "Log4j2 " + ConfigurationScheduler.class.getSimpleName();
    private static final int MAX_SCHEDULED_ITEMS = 5;
    private ScheduledExecutorService executorService;
    private int scheduledItems = 0;

    @Override
    public void start() {
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        if (this.isExecutorServiceSet()) {
            LOGGER.debug("{} shutting down threads in {}", (Object)SIMPLE_NAME, (Object)this.getExecutorService());
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(l2, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                this.executorService.shutdownNow();
                try {
                    this.executorService.awaitTermination(l2, timeUnit);
                }
                catch (InterruptedException interruptedException2) {
                    LOGGER.warn("ConfigurationScheduler stopped but some scheduled services may not have completed.");
                }
                Thread.currentThread().interrupt();
            }
        }
        this.setStopped();
        return true;
    }

    public boolean isExecutorServiceSet() {
        return this.executorService != null;
    }

    public void incrementScheduledItems() {
        if (this.isExecutorServiceSet()) {
            LOGGER.error("{} attempted to increment scheduled items after start", (Object)SIMPLE_NAME);
        } else {
            ++this.scheduledItems;
        }
    }

    public void decrementScheduledItems() {
        if (!this.isStarted() && this.scheduledItems > 0) {
            --this.scheduledItems;
        }
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        return this.getExecutorService().schedule(callable, l2, timeUnit);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.getExecutorService().schedule(runnable, l2, timeUnit);
    }

    public CronScheduledFuture<?> scheduleWithCron(CronExpression cronExpression, Runnable runnable) {
        return this.scheduleWithCron(cronExpression, new Date(), runnable);
    }

    public CronScheduledFuture<?> scheduleWithCron(CronExpression cronExpression, Date date, Runnable runnable) {
        Date date2 = cronExpression.getNextValidTimeAfter(date == null ? new Date() : date);
        ConfigurationScheduler$CronRunnable configurationScheduler$CronRunnable = new ConfigurationScheduler$CronRunnable(this, runnable, cronExpression);
        ScheduledFuture<?> scheduledFuture = this.schedule(configurationScheduler$CronRunnable, this.nextFireInterval(date2), TimeUnit.MILLISECONDS);
        CronScheduledFuture cronScheduledFuture = new CronScheduledFuture(scheduledFuture, date2);
        configurationScheduler$CronRunnable.setScheduledFuture(cronScheduledFuture);
        LOGGER.debug("Scheduled cron expression {} to fire at {}", (Object)cronExpression.getCronExpression(), (Object)date2);
        return cronScheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.getExecutorService().scheduleAtFixedRate(runnable, l2, l3, timeUnit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.getExecutorService().scheduleWithFixedDelay(runnable, l2, l3, timeUnit);
    }

    public long nextFireInterval(Date date) {
        return date.getTime() - new Date().getTime();
    }

    private ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            if (this.scheduledItems > 0) {
                LOGGER.debug("{} starting {} threads", (Object)SIMPLE_NAME, (Object)this.scheduledItems);
                this.scheduledItems = Math.min(this.scheduledItems, 5);
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.scheduledItems, Log4jThreadFactory.createDaemonThreadFactory("Scheduled"));
                scheduledThreadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
                scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                this.executorService = scheduledThreadPoolExecutor;
            } else {
                LOGGER.debug("{}: No scheduled items", (Object)SIMPLE_NAME);
            }
        }
        return this.executorService;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ConfigurationScheduler {");
        BlockingQueue<Runnable> blockingQueue = ((ScheduledThreadPoolExecutor)this.executorService).getQueue();
        boolean bl2 = true;
        for (Runnable runnable : blockingQueue) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(runnable.toString());
            bl2 = false;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ String access$100() {
        return SIMPLE_NAME;
    }
}

