/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory$Factory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.OrderComparator;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public abstract class ConfigurationFactory
extends ConfigurationBuilderFactory {
    public static final String CONFIGURATION_FACTORY_PROPERTY = "log4j.configurationFactory";
    public static final String CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";
    public static final String CATEGORY = "ConfigurationFactory";
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected static final String TEST_PREFIX = "log4j2-test";
    protected static final String DEFAULT_PREFIX = "log4j2";
    private static final String CLASS_LOADER_SCHEME = "classloader";
    private static final String CLASS_PATH_SCHEME = "classpath";
    private static volatile List<ConfigurationFactory> factories = null;
    private static ConfigurationFactory configFactory = new ConfigurationFactory$Factory(null);
    protected final StrSubstitutor substitutor = new StrSubstitutor(new Interpolator());
    private static final Lock LOCK = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationFactory getInstance() {
        if (factories == null) {
            LOCK.lock();
            try {
                if (factories == null) {
                    ArrayList<ConfigurationFactory> arrayList = new ArrayList<ConfigurationFactory>();
                    String string = PropertiesUtil.getProperties().getStringProperty(CONFIGURATION_FACTORY_PROPERTY);
                    if (string != null) {
                        ConfigurationFactory.addFactory(arrayList, string);
                    }
                    PluginManager pluginManager = new PluginManager(CATEGORY);
                    pluginManager.collectPlugins();
                    Map<String, PluginType<?>> map = pluginManager.getPlugins();
                    ArrayList<Class<ConfigurationFactory>> arrayList2 = new ArrayList<Class<ConfigurationFactory>>(map.size());
                    for (PluginType<?> object : map.values()) {
                        try {
                            arrayList2.add(object.getPluginClass().asSubclass(ConfigurationFactory.class));
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Unable to add class {}", (Object)object.getPluginClass(), (Object)exception);
                        }
                    }
                    Collections.sort(arrayList2, OrderComparator.getInstance());
                    for (Class clazz : arrayList2) {
                        ConfigurationFactory.addFactory(arrayList, clazz);
                    }
                    factories = Collections.unmodifiableList(arrayList);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        LOGGER.debug("Using configurationFactory {}", (Object)configFactory);
        return configFactory;
    }

    private static void addFactory(Collection<ConfigurationFactory> collection, String string) {
        try {
            ConfigurationFactory.addFactory(collection, LoaderUtil.loadClass(string).asSubclass(ConfigurationFactory.class));
        }
        catch (Exception exception) {
            LOGGER.error("Unable to load class {}", (Object)string, (Object)exception);
        }
    }

    private static void addFactory(Collection<ConfigurationFactory> collection, Class<? extends ConfigurationFactory> clazz) {
        try {
            collection.add(ReflectionUtil.instantiate(clazz));
        }
        catch (Exception exception) {
            LOGGER.error("Unable to create instance of {}", (Object)clazz.getName(), (Object)exception);
        }
    }

    public static void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        configFactory = configurationFactory;
    }

    public static void resetConfigurationFactory() {
        configFactory = new ConfigurationFactory$Factory(null);
    }

    public static void removeConfigurationFactory(ConfigurationFactory configurationFactory) {
        if (configFactory == configurationFactory) {
            configFactory = new ConfigurationFactory$Factory(null);
        }
    }

    protected abstract String[] getSupportedTypes();

    protected boolean isActive() {
        return true;
    }

    public abstract Configuration getConfiguration(LoggerContext var1, ConfigurationSource var2);

    public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI) {
        ConfigurationSource configurationSource;
        if (!this.isActive()) {
            return null;
        }
        if (uRI != null && (configurationSource = this.getInputFromUri(uRI)) != null) {
            return this.getConfiguration(loggerContext, configurationSource);
        }
        return null;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI, ClassLoader classLoader) {
        Configuration configuration;
        String string2;
        ConfigurationSource configurationSource;
        if (!this.isActive()) {
            return null;
        }
        if (classLoader == null) {
            return this.getConfiguration(loggerContext, string, uRI);
        }
        if (ConfigurationFactory.isClassLoaderUri(uRI) && (configurationSource = this.getInputFromResource(string2 = ConfigurationFactory.extractClassLoaderUriPath(uRI), classLoader)) != null && (configuration = this.getConfiguration(loggerContext, configurationSource)) != null) {
            return configuration;
        }
        return this.getConfiguration(loggerContext, string, uRI);
    }

    protected ConfigurationSource getInputFromUri(URI uRI) {
        File file = FileUtils.fileFromUri(uRI);
        if (file != null && file.exists() && file.canRead()) {
            try {
                return new ConfigurationSource((InputStream)new FileInputStream(file), file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.error("Cannot locate file {}", (Object)uRI.getPath(), (Object)fileNotFoundException);
            }
        }
        if (ConfigurationFactory.isClassLoaderUri(uRI)) {
            ClassLoader classLoader = LoaderUtil.getThreadContextClassLoader();
            String string = ConfigurationFactory.extractClassLoaderUriPath(uRI);
            ConfigurationSource configurationSource = this.getInputFromResource(string, classLoader);
            if (configurationSource != null) {
                return configurationSource;
            }
        }
        if (!uRI.isAbsolute()) {
            LOGGER.error("File not found in file system or classpath: {}", (Object)uRI.toString());
            return null;
        }
        try {
            return new ConfigurationSource(uRI.toURL().openStream(), uRI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.error("Invalid URL {}", (Object)uRI.toString(), (Object)malformedURLException);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to access {}", (Object)uRI.toString(), (Object)exception);
        }
        return null;
    }

    private static boolean isClassLoaderUri(URI uRI) {
        if (uRI == null) {
            return false;
        }
        String string = uRI.getScheme();
        return string == null || string.equals(CLASS_LOADER_SCHEME) || string.equals(CLASS_PATH_SCHEME);
    }

    private static String extractClassLoaderUriPath(URI uRI) {
        return uRI.getScheme() == null ? uRI.getPath() : uRI.getSchemeSpecificPart();
    }

    protected ConfigurationSource getInputFromString(String string, ClassLoader classLoader) {
        try {
            URL uRL = new URL(string);
            return new ConfigurationSource(uRL.openStream(), FileUtils.fileFromUri(uRL.toURI()));
        }
        catch (Exception exception) {
            ConfigurationSource configurationSource = this.getInputFromResource(string, classLoader);
            if (configurationSource == null) {
                try {
                    File file = new File(string);
                    return new ConfigurationSource((InputStream)new FileInputStream(file), file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOGGER.catching(Level.DEBUG, fileNotFoundException);
                }
            }
            return configurationSource;
        }
    }

    protected ConfigurationSource getInputFromResource(String string, ClassLoader classLoader) {
        URL uRL = Loader.getResource(string, classLoader);
        if (uRL == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            LOGGER.catching(Level.DEBUG, iOException);
            return null;
        }
        if (inputStream == null) {
            return null;
        }
        if (FileUtils.isFile(uRL)) {
            try {
                return new ConfigurationSource(inputStream, FileUtils.fileFromUri(uRL.toURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.catching(Level.DEBUG, uRISyntaxException);
            }
        }
        return new ConfigurationSource(inputStream, uRL);
    }

    static List<ConfigurationFactory> getFactories() {
        return factories;
    }
}

