/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.net.URI;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationFactory$1;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

class ConfigurationFactory$Factory
extends ConfigurationFactory {
    private static final String ALL_TYPES = "*";

    private ConfigurationFactory$Factory() {
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI) {
        Object object;
        if (uRI == null) {
            object = this.substitutor.replace(PropertiesUtil.getProperties().getStringProperty("log4j.configurationFile"));
            if (object != null) {
                String[] stringArray = ((String)object).split(",");
                if (stringArray.length > 1) {
                    ArrayList<AbstractConfiguration> arrayList = new ArrayList<AbstractConfiguration>();
                    for (String string2 : stringArray) {
                        Configuration configuration = this.getConfiguration(loggerContext, string2.trim());
                        if (configuration == null || !(configuration instanceof AbstractConfiguration)) {
                            LOGGER.error("Failed to created configuration at {}", (Object)string2);
                            return null;
                        }
                        arrayList.add((AbstractConfiguration)configuration);
                    }
                    return new CompositeConfiguration(arrayList);
                }
                return this.getConfiguration(loggerContext, (String)object);
            }
            for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
                String[] stringArray = configurationFactory.getSupportedTypes();
                if (stringArray == null) continue;
                for (String string3 : stringArray) {
                    Configuration configuration;
                    if (!string3.equals(ALL_TYPES) || (configuration = configurationFactory.getConfiguration(loggerContext, string, uRI)) == null) continue;
                    return configuration;
                }
            }
        } else {
            object = uRI.toString();
            for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
                String[] stringArray = configurationFactory.getSupportedTypes();
                if (stringArray == null) continue;
                for (String string4 : stringArray) {
                    Configuration configuration;
                    if (!string4.equals(ALL_TYPES) && !((String)object).endsWith(string4) || (configuration = configurationFactory.getConfiguration(loggerContext, string, uRI)) == null) continue;
                    return configuration;
                }
            }
        }
        if ((object = this.getConfiguration(loggerContext, true, string)) == null && (object = this.getConfiguration(loggerContext, true, null)) == null && (object = this.getConfiguration(loggerContext, false, string)) == null) {
            object = this.getConfiguration(loggerContext, false, null);
        }
        if (object != null) {
            return object;
        }
        LOGGER.error("No log4j2 configuration file found. Using default configuration: logging only errors to the console. Set system property 'org.apache.logging.log4j.simplelog.StatusLogger.level' to TRACE to show Log4j2 internal initialization logging.");
        return new DefaultConfiguration();
    }

    private Configuration getConfiguration(LoggerContext loggerContext, String string) {
        ConfigurationSource configurationSource = null;
        try {
            configurationSource = this.getInputFromUri(NetUtils.toURI(string));
        }
        catch (Exception exception) {
            LOGGER.catching(Level.DEBUG, exception);
        }
        if (configurationSource == null) {
            ClassLoader classLoader = LoaderUtil.getThreadContextClassLoader();
            configurationSource = this.getInputFromString(string, classLoader);
        }
        if (configurationSource != null) {
            for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
                String[] stringArray = configurationFactory.getSupportedTypes();
                if (stringArray == null) continue;
                for (String string2 : stringArray) {
                    Configuration configuration;
                    if (!string2.equals(ALL_TYPES) && !string.endsWith(string2) || (configuration = configurationFactory.getConfiguration(loggerContext, configurationSource)) == null) continue;
                    return configuration;
                }
            }
        }
        return null;
    }

    private Configuration getConfiguration(LoggerContext loggerContext, boolean bl2, String string) {
        boolean bl3 = Strings.isNotEmpty(string);
        ClassLoader classLoader = LoaderUtil.getThreadContextClassLoader();
        for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
            String string2 = bl2 ? "log4j2-test" : "log4j2";
            String[] stringArray = configurationFactory.getSupportedTypes();
            if (stringArray == null) continue;
            for (String string3 : stringArray) {
                String string4;
                ConfigurationSource configurationSource;
                if (string3.equals(ALL_TYPES) || (configurationSource = this.getInputFromResource(string4 = bl3 ? string2 + string + string3 : string2 + string3, classLoader)) == null) continue;
                return configurationFactory.getConfiguration(loggerContext, configurationSource);
            }
        }
        return null;
    }

    @Override
    public String[] getSupportedTypes() {
        return null;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        if (configurationSource != null) {
            String string = configurationSource.getLocation();
            for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
                String[] stringArray = configurationFactory.getSupportedTypes();
                if (stringArray == null) continue;
                for (String string2 : stringArray) {
                    if (!string2.equals(ALL_TYPES) && (string == null || !string.endsWith(string2))) continue;
                    Configuration configuration = configurationFactory.getConfiguration(loggerContext, configurationSource);
                    if (configuration != null) {
                        LOGGER.debug("Loaded configuration from {}", (Object)configurationSource);
                        return configuration;
                    }
                    LOGGER.error("Cannot determine the ConfigurationFactory to use for {}", (Object)string);
                    return null;
                }
            }
        }
        LOGGER.error("Cannot process configuration, input source is null");
        return null;
    }

    /* synthetic */ ConfigurationFactory$Factory(ConfigurationFactory$1 configurationFactory$1) {
        this();
    }
}

