/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$1;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$2;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$3;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$4;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$Log4jEventWrapper;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$Log4jEventWrapperHandler;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DisruptorUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.util.ExecutorServices;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.message.ReusableMessage;

public class AsyncLoggerConfigDisruptor
extends AbstractLifeCycle
implements AsyncLoggerConfigDelegate {
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final EventFactory<AsyncLoggerConfigDisruptor$Log4jEventWrapper> FACTORY = new AsyncLoggerConfigDisruptor$1();
    private static final EventFactory<AsyncLoggerConfigDisruptor$Log4jEventWrapper> MUTABLE_FACTORY = new AsyncLoggerConfigDisruptor$2();
    private static final EventTranslatorTwoArg<AsyncLoggerConfigDisruptor$Log4jEventWrapper, LogEvent, AsyncLoggerConfig> TRANSLATOR = new AsyncLoggerConfigDisruptor$3();
    private static final EventTranslatorTwoArg<AsyncLoggerConfigDisruptor$Log4jEventWrapper, LogEvent, AsyncLoggerConfig> MUTABLE_TRANSLATOR = new AsyncLoggerConfigDisruptor$4();
    private static final ThreadFactory THREAD_FACTORY = Log4jThreadFactory.createDaemonThreadFactory("AsyncLoggerConfig");
    private int ringBufferSize;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;
    private Boolean mutable = Boolean.FALSE;
    private volatile Disruptor<AsyncLoggerConfigDisruptor$Log4jEventWrapper> disruptor;
    private ExecutorService executor;
    private long backgroundThreadId;
    private EventFactory<AsyncLoggerConfigDisruptor$Log4jEventWrapper> factory;
    private EventTranslatorTwoArg<AsyncLoggerConfigDisruptor$Log4jEventWrapper, LogEvent, AsyncLoggerConfig> translator;

    @Override
    public void setLogEventFactory(LogEventFactory logEventFactory) {
        this.mutable = this.mutable != false || logEventFactory instanceof ReusableLogEventFactory;
    }

    @Override
    public synchronized void start() {
        if (this.disruptor != null) {
            LOGGER.trace("AsyncLoggerConfigDisruptor not starting new disruptor for this configuration, using existing object.");
            return;
        }
        LOGGER.trace("AsyncLoggerConfigDisruptor creating new disruptor for this configuration.");
        this.ringBufferSize = DisruptorUtil.calculateRingBufferSize("AsyncLoggerConfig.RingBufferSize");
        WaitStrategy waitStrategy = DisruptorUtil.createWaitStrategy("AsyncLoggerConfig.WaitStrategy");
        this.executor = Executors.newSingleThreadExecutor(THREAD_FACTORY);
        this.backgroundThreadId = DisruptorUtil.getExecutorThreadId(this.executor);
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.translator = this.mutable != false ? MUTABLE_TRANSLATOR : TRANSLATOR;
        this.factory = this.mutable != false ? MUTABLE_FACTORY : FACTORY;
        this.disruptor = new Disruptor(this.factory, this.ringBufferSize, (Executor)this.executor, ProducerType.MULTI, waitStrategy);
        ExceptionHandler<AsyncLoggerConfigDisruptor$Log4jEventWrapper> exceptionHandler = DisruptorUtil.getAsyncLoggerConfigExceptionHandler();
        this.disruptor.handleExceptionsWith(exceptionHandler);
        AsyncLoggerConfigDisruptor$Log4jEventWrapperHandler[] asyncLoggerConfigDisruptor$Log4jEventWrapperHandlerArray = new AsyncLoggerConfigDisruptor$Log4jEventWrapperHandler[]{new AsyncLoggerConfigDisruptor$Log4jEventWrapperHandler(null)};
        this.disruptor.handleEventsWith((EventHandler[])asyncLoggerConfigDisruptor$Log4jEventWrapperHandlerArray);
        LOGGER.debug("Starting AsyncLoggerConfig disruptor for this configuration with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", (Object)this.disruptor.getRingBuffer().getBufferSize(), (Object)waitStrategy.getClass().getSimpleName(), (Object)exceptionHandler);
        this.disruptor.start();
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        Disruptor<AsyncLoggerConfigDisruptor$Log4jEventWrapper> disruptor = this.disruptor;
        if (disruptor == null) {
            LOGGER.trace("AsyncLoggerConfigDisruptor: disruptor for this configuration already shut down.");
            return true;
        }
        this.setStopping();
        LOGGER.trace("AsyncLoggerConfigDisruptor: shutting down disruptor for this configuration.");
        this.disruptor = null;
        for (int i2 = 0; AsyncLoggerConfigDisruptor.hasBacklog(disruptor) && i2 < 200; ++i2) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        disruptor.shutdown();
        LOGGER.trace("AsyncLoggerConfigDisruptor: shutting down disruptor executor for this configuration.");
        ExecutorServices.shutdown(this.executor, l2, timeUnit, this.toString());
        this.executor = null;
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncLoggerConfigDisruptor: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    private static boolean hasBacklog(Disruptor<?> disruptor) {
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        return !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    @Override
    public EventRoute getEventRoute(Level level) {
        int n2 = this.remainingDisruptorCapacity();
        if (n2 < 0) {
            return EventRoute.DISCARD;
        }
        return this.asyncQueueFullPolicy.getRoute(this.backgroundThreadId, level);
    }

    private int remainingDisruptorCapacity() {
        Disruptor<AsyncLoggerConfigDisruptor$Log4jEventWrapper> disruptor = this.disruptor;
        if (this.hasLog4jBeenShutDown(disruptor)) {
            return -1;
        }
        return (int)disruptor.getRingBuffer().remainingCapacity();
    }

    private boolean hasLog4jBeenShutDown(Disruptor<AsyncLoggerConfigDisruptor$Log4jEventWrapper> disruptor) {
        if (disruptor == null) {
            LOGGER.warn("Ignoring log event after log4j was shut down");
            return true;
        }
        return false;
    }

    @Override
    public void enqueueEvent(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        try {
            LogEvent logEvent2 = this.prepareEvent(logEvent);
            this.enqueue(logEvent2, asyncLoggerConfig);
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.warn("Ignoring log event after log4j was shut down.");
        }
    }

    private LogEvent prepareEvent(LogEvent logEvent) {
        LogEvent logEvent2 = this.ensureImmutable(logEvent);
        if (logEvent2 instanceof Log4jLogEvent && logEvent2.getMessage() instanceof ReusableMessage) {
            ((Log4jLogEvent)logEvent2).makeMessageImmutable();
        }
        return logEvent2;
    }

    private void enqueue(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        this.disruptor.getRingBuffer().publishEvent(this.translator, (Object)logEvent, (Object)asyncLoggerConfig);
    }

    @Override
    public boolean tryEnqueue(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        LogEvent logEvent2 = this.prepareEvent(logEvent);
        return this.disruptor.getRingBuffer().tryPublishEvent(this.translator, (Object)logEvent2, (Object)asyncLoggerConfig);
    }

    private LogEvent ensureImmutable(LogEvent logEvent) {
        LogEvent logEvent2 = logEvent;
        if (logEvent instanceof RingBufferLogEvent) {
            logEvent2 = ((RingBufferLogEvent)logEvent).createMemento();
        }
        return logEvent2;
    }

    @Override
    public RingBufferAdmin createRingBufferAdmin(String string, String string2) {
        return RingBufferAdmin.forAsyncLoggerConfig(this.disruptor.getRingBuffer(), string, string2);
    }
}

