/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import org.apache.logging.log4j.core.appender.routing.Route;
import org.apache.logging.log4j.core.appender.routing.Routes;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.util.Builder;

public class Routes$Builder
implements Builder<Routes> {
    @PluginConfiguration
    private Configuration configuration;
    @PluginAttribute(value="pattern")
    private String pattern;
    @PluginElement(value="Script")
    private AbstractScript patternScript;
    @PluginElement(value="Routes")
    @Required
    private Route[] routes;

    @Override
    public Routes build() {
        if (this.routes == null || this.routes.length == 0) {
            Routes.access$000().error("No Routes configured.");
            return null;
        }
        if (this.patternScript != null && this.pattern != null) {
            Routes.access$000().warn("In a Routes element, you must configure either a Script element or a pattern attribute.");
        }
        if (this.patternScript != null) {
            if (this.configuration == null) {
                Routes.access$000().error("No Configuration defined for Routes; required for Script");
            } else {
                this.configuration.getScriptManager().addScript(this.patternScript);
            }
        }
        return new Routes(this.configuration, this.patternScript, this.pattern, this.routes);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getPattern() {
        return this.pattern;
    }

    public AbstractScript getPatternScript() {
        return this.patternScript;
    }

    public Route[] getRoutes() {
        return this.routes;
    }

    public Routes$Builder withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Routes$Builder withPattern(String string) {
        this.pattern = string;
        return this;
    }

    public Routes$Builder withPatternScript(AbstractScript abstractScript) {
        this.patternScript = abstractScript;
        return this;
    }

    public Routes$Builder withRoutes(Route[] routeArray) {
        this.routes = routeArray;
        return this;
    }
}

