/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.Serializable;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="SortByModificationTime", category="Core", printObject=true)
public class PathSortByModificationTime
implements Serializable,
PathSorter {
    private static final long serialVersionUID = 1L;
    private final boolean recentFirst;
    private final int multiplier;

    public PathSortByModificationTime(boolean bl2) {
        this.recentFirst = bl2;
        this.multiplier = bl2 ? 1 : -1;
    }

    @PluginFactory
    public static PathSorter createSorter(@PluginAttribute(value="recentFirst", defaultBoolean=true) boolean bl2) {
        return new PathSortByModificationTime(bl2);
    }

    public boolean isRecentFirst() {
        return this.recentFirst;
    }

    @Override
    public int compare(PathWithAttributes pathWithAttributes, PathWithAttributes pathWithAttributes2) {
        long l2 = pathWithAttributes.getAttributes().lastModifiedTime().toMillis();
        long l3 = pathWithAttributes2.getAttributes().lastModifiedTime().toMillis();
        int n2 = Long.signum(l3 - l2);
        if (n2 == 0) {
            try {
                n2 = pathWithAttributes2.getPath().compareTo(pathWithAttributes.getPath());
            }
            catch (ClassCastException classCastException) {
                n2 = pathWithAttributes2.getPath().toString().compareTo(pathWithAttributes.getPath().toString());
            }
        }
        return this.multiplier * n2;
    }
}

