/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager$FactoryData;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager$RollingRandomAccessFileManagerFactory;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;

public class RollingRandomAccessFileManager
extends RollingFileManager {
    public static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RollingRandomAccessFileManager$RollingRandomAccessFileManagerFactory FACTORY = new RollingRandomAccessFileManager$RollingRandomAccessFileManagerFactory(null);
    private RandomAccessFile randomAccessFile;
    private final ThreadLocal<Boolean> isEndOfBatch = new ThreadLocal();

    public RollingRandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile randomAccessFile, String string, String string2, OutputStream outputStream, boolean bl2, boolean bl3, int n2, long l2, long l3, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, boolean bl4) {
        super(loggerContext, string, string2, outputStream, bl2, false, l2, l3, triggeringPolicy, rolloverStrategy, string3, layout, bl4, ByteBuffer.wrap(new byte[n2]));
        this.randomAccessFile = randomAccessFile;
        this.isEndOfBatch.set(Boolean.FALSE);
        this.writeHeader();
    }

    private void writeHeader() {
        if (this.layout == null) {
            return;
        }
        byte[] byArray = this.layout.getHeader();
        if (byArray == null) {
            return;
        }
        try {
            if (this.randomAccessFile.length() == 0L) {
                this.randomAccessFile.write(byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
            this.logError("Unable to write header", iOException);
        }
    }

    public static RollingRandomAccessFileManager getRollingRandomAccessFileManager(String string, String string2, boolean bl2, boolean bl3, int n2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, Configuration configuration) {
        return (RollingRandomAccessFileManager)RollingRandomAccessFileManager.getManager(string, new RollingRandomAccessFileManager$FactoryData(string2, bl2, bl3, n2, triggeringPolicy, rolloverStrategy, string3, layout, configuration), FACTORY);
    }

    public Boolean isEndOfBatch() {
        return this.isEndOfBatch.get();
    }

    public void setEndOfBatch(boolean bl2) {
        this.isEndOfBatch.set(bl2);
    }

    @Override
    protected synchronized void write(byte[] byArray, int n2, int n3, boolean bl2) {
        super.write(byArray, n2, n3, bl2);
    }

    @Override
    protected synchronized void writeToDestination(byte[] byArray, int n2, int n3) {
        try {
            this.randomAccessFile.write(byArray, n2, n3);
            this.size += (long)n3;
        }
        catch (IOException iOException) {
            String string = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException(string, iOException);
        }
    }

    @Override
    protected void createFileAfterRollover() {
        this.randomAccessFile = new RandomAccessFile(this.getFileName(), "rw");
        if (this.isAppend()) {
            this.randomAccessFile.seek(this.randomAccessFile.length());
        }
        this.writeHeader();
    }

    @Override
    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
    }

    @Override
    public synchronized boolean closeOutputStream() {
        this.flush();
        try {
            this.randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            this.logError("Unable to close RandomAccessFile", iOException);
            return false;
        }
    }

    @Override
    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    @Override
    public void updateData(Object object) {
        RollingRandomAccessFileManager$FactoryData rollingRandomAccessFileManager$FactoryData = (RollingRandomAccessFileManager$FactoryData)object;
        this.setRolloverStrategy(rollingRandomAccessFileManager$FactoryData.getRolloverStrategy());
        this.setTriggeringPolicy(rollingRandomAccessFileManager$FactoryData.getTriggeringPolicy());
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1200() {
        return LOGGER;
    }
}

