/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager$AsyncAction;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager$EmptyQueue;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager$FactoryData;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager$RollingFileManagerFactory;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;

public class RollingFileManager
extends FileManager {
    private static RollingFileManager$RollingFileManagerFactory factory = new RollingFileManager$RollingFileManagerFactory();
    private static final int MAX_TRIES = 3;
    private static final int MIN_DURATION = 100;
    protected long size;
    private long initialTime;
    private final PatternProcessor patternProcessor;
    private final Semaphore semaphore = new Semaphore(1);
    private final Log4jThreadFactory threadFactory = Log4jThreadFactory.createThreadFactory("RollingFileManager");
    private volatile TriggeringPolicy triggeringPolicy;
    private volatile RolloverStrategy rolloverStrategy;
    private volatile boolean renameEmptyFiles = false;
    private volatile boolean initialized = false;
    private volatile String fileName;
    private FileExtension fileExtension;
    private ExecutorService asyncExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new RollingFileManager$EmptyQueue(), this.threadFactory);
    private static final AtomicReferenceFieldUpdater<RollingFileManager, TriggeringPolicy> triggeringPolicyUpdater = AtomicReferenceFieldUpdater.newUpdater(RollingFileManager.class, TriggeringPolicy.class, "triggeringPolicy");
    private static final AtomicReferenceFieldUpdater<RollingFileManager, RolloverStrategy> rolloverStrategyUpdater = AtomicReferenceFieldUpdater.newUpdater(RollingFileManager.class, RolloverStrategy.class, "rolloverStrategy");

    @Deprecated
    protected RollingFileManager(String string, String string2, OutputStream outputStream, boolean bl2, long l2, long l3, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, int n2, boolean bl3) {
        this(string, string2, outputStream, bl2, l2, l3, triggeringPolicy, rolloverStrategy, string3, layout, bl3, ByteBuffer.wrap(new byte[Constants.ENCODER_BYTE_BUFFER_SIZE]));
    }

    @Deprecated
    protected RollingFileManager(String string, String string2, OutputStream outputStream, boolean bl2, long l2, long l3, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, boolean bl3, ByteBuffer byteBuffer) {
        super(string, outputStream, bl2, false, string3, layout, bl3, byteBuffer);
        this.size = l2;
        this.initialTime = l3;
        this.triggeringPolicy = triggeringPolicy;
        this.rolloverStrategy = rolloverStrategy;
        this.patternProcessor = new PatternProcessor(string2);
        this.patternProcessor.setPrevFileTime(l3);
        this.fileName = string;
        this.fileExtension = FileExtension.lookupForFile(string2);
    }

    protected RollingFileManager(LoggerContext loggerContext, String string, String string2, OutputStream outputStream, boolean bl2, boolean bl3, long l2, long l3, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, boolean bl4, ByteBuffer byteBuffer) {
        super(loggerContext, string, outputStream, bl2, false, bl3, string3, layout, bl4, byteBuffer);
        this.size = l2;
        this.initialTime = l3;
        this.triggeringPolicy = triggeringPolicy;
        this.rolloverStrategy = rolloverStrategy;
        this.patternProcessor = new PatternProcessor(string2);
        this.patternProcessor.setPrevFileTime(l3);
        this.fileName = string;
        this.fileExtension = FileExtension.lookupForFile(string2);
    }

    public void initialize() {
        if (!this.initialized) {
            LOGGER.debug("Initializing triggering policy {}", (Object)this.triggeringPolicy);
            this.initialized = true;
            this.triggeringPolicy.initialize(this);
            if (this.triggeringPolicy instanceof LifeCycle) {
                ((LifeCycle)((Object)this.triggeringPolicy)).start();
            }
        }
    }

    public static RollingFileManager getFileManager(String string, String string2, boolean bl2, boolean bl3, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, int n2, boolean bl4, boolean bl5, Configuration configuration) {
        String string4 = string == null ? string2 : string;
        return (RollingFileManager)RollingFileManager.getManager(string4, new RollingFileManager$FactoryData(string, string2, bl2, bl3, triggeringPolicy, rolloverStrategy, string3, layout, n2, bl4, bl5, configuration), factory);
    }

    @Override
    public String getFileName() {
        if (this.rolloverStrategy instanceof DirectFileRolloverStrategy) {
            this.fileName = ((DirectFileRolloverStrategy)((Object)this.rolloverStrategy)).getCurrentFileName(this);
        }
        return this.fileName;
    }

    public FileExtension getFileExtension() {
        return this.fileExtension;
    }

    @Override
    protected synchronized void write(byte[] byArray, int n2, int n3, boolean bl2) {
        super.write(byArray, n2, n3, bl2);
    }

    @Override
    protected synchronized void writeToDestination(byte[] byArray, int n2, int n3) {
        this.size += (long)n3;
        super.writeToDestination(byArray, n2, n3);
    }

    public boolean isRenameEmptyFiles() {
        return this.renameEmptyFiles;
    }

    public void setRenameEmptyFiles(boolean bl2) {
        this.renameEmptyFiles = bl2;
    }

    public long getFileSize() {
        return this.size + (long)this.byteBuffer.position();
    }

    public long getFileTime() {
        return this.initialTime;
    }

    public synchronized void checkRollover(LogEvent logEvent) {
        if (this.triggeringPolicy.isTriggeringEvent(logEvent)) {
            this.rollover();
        }
    }

    @Override
    public boolean releaseSub(long l2, TimeUnit timeUnit) {
        boolean bl2;
        block13: {
            LOGGER.debug("Shutting down RollingFileManager {}" + this.getName());
            boolean bl3 = true;
            if (this.triggeringPolicy instanceof LifeCycle2) {
                bl3 &= ((LifeCycle2)((Object)this.triggeringPolicy)).stop(l2, timeUnit);
            } else if (this.triggeringPolicy instanceof LifeCycle) {
                ((LifeCycle)((Object)this.triggeringPolicy)).stop();
                bl3 &= true;
            }
            bl2 = super.releaseSub(l2, timeUnit) && bl3;
            this.asyncExecutor.shutdown();
            try {
                long l3 = timeUnit.toMillis(l2);
                long l4 = 100L < l3 ? l3 : 100L;
                for (int i2 = 1; i2 <= 3 && !this.asyncExecutor.isTerminated(); ++i2) {
                    this.asyncExecutor.awaitTermination(l4 * (long)i2, TimeUnit.MILLISECONDS);
                }
                if (this.asyncExecutor.isTerminated()) {
                    LOGGER.debug("All asynchronous threads have terminated");
                    break block13;
                }
                this.asyncExecutor.shutdownNow();
                try {
                    this.asyncExecutor.awaitTermination(l2, timeUnit);
                    if (this.asyncExecutor.isTerminated()) {
                        LOGGER.debug("All asynchronous threads have terminated");
                        break block13;
                    }
                    LOGGER.debug("RollingFileManager shutting down but some asynchronous services may not have completed");
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warn("RollingFileManager stopped but some asynchronous services may not have completed.");
                }
            }
            catch (InterruptedException interruptedException) {
                this.asyncExecutor.shutdownNow();
                try {
                    this.asyncExecutor.awaitTermination(l2, timeUnit);
                    if (this.asyncExecutor.isTerminated()) {
                        LOGGER.debug("All asynchronous threads have terminated");
                    }
                }
                catch (InterruptedException interruptedException2) {
                    LOGGER.warn("RollingFileManager stopped but some asynchronous services may not have completed.");
                }
                Thread.currentThread().interrupt();
            }
        }
        LOGGER.debug("RollingFileManager shutdown completed with status {}", (Object)bl2);
        return bl2;
    }

    public synchronized void rollover() {
        if (!this.hasOutputStream()) {
            return;
        }
        if (this.rollover(this.rolloverStrategy)) {
            try {
                this.size = 0L;
                this.initialTime = System.currentTimeMillis();
                this.createFileAfterRollover();
            }
            catch (IOException iOException) {
                this.logError("Failed to create file after rollover", iOException);
            }
        }
    }

    protected void createFileAfterRollover() {
        this.setOutputStream(this.createOutputStream());
    }

    public PatternProcessor getPatternProcessor() {
        return this.patternProcessor;
    }

    public void setTriggeringPolicy(TriggeringPolicy triggeringPolicy) {
        triggeringPolicy.initialize(this);
        TriggeringPolicy triggeringPolicy2 = this.triggeringPolicy;
        int n2 = 0;
        boolean bl2 = false;
        while (!(bl2 = triggeringPolicyUpdater.compareAndSet(this, this.triggeringPolicy, triggeringPolicy)) && ++n2 < 3) {
        }
        if (bl2) {
            if (triggeringPolicy instanceof LifeCycle) {
                ((LifeCycle)((Object)triggeringPolicy)).start();
            }
            if (triggeringPolicy2 instanceof LifeCycle) {
                ((LifeCycle)((Object)triggeringPolicy2)).stop();
            }
        } else if (triggeringPolicy instanceof LifeCycle) {
            ((LifeCycle)((Object)triggeringPolicy)).stop();
        }
    }

    public void setRolloverStrategy(RolloverStrategy rolloverStrategy) {
        rolloverStrategyUpdater.compareAndSet(this, this.rolloverStrategy, rolloverStrategy);
    }

    public <T extends TriggeringPolicy> T getTriggeringPolicy() {
        return (T)this.triggeringPolicy;
    }

    public RolloverStrategy getRolloverStrategy() {
        return this.rolloverStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollover(RolloverStrategy rolloverStrategy) {
        boolean bl2 = false;
        try {
            this.semaphore.acquire();
            bl2 = true;
        }
        catch (InterruptedException interruptedException) {
            this.logError("Thread interrupted while attempting to check rollover", interruptedException);
            return false;
        }
        boolean bl3 = true;
        try {
            RolloverDescription rolloverDescription = rolloverStrategy.rollover(this);
            if (rolloverDescription != null) {
                this.writeFooter();
                this.closeOutputStream();
                if (rolloverDescription.getSynchronous() != null) {
                    LOGGER.debug("RollingFileManager executing synchronous {}", (Object)rolloverDescription.getSynchronous());
                    try {
                        bl3 = rolloverDescription.getSynchronous().execute();
                    }
                    catch (Exception exception) {
                        bl3 = false;
                        this.logError("Caught error in synchronous task", exception);
                    }
                }
                if (bl3 && rolloverDescription.getAsynchronous() != null) {
                    LOGGER.debug("RollingFileManager executing async {}", (Object)rolloverDescription.getAsynchronous());
                    this.asyncExecutor.execute(new RollingFileManager$AsyncAction(rolloverDescription.getAsynchronous(), this));
                    bl2 = false;
                }
                boolean bl4 = true;
                return bl4;
            }
            boolean bl5 = false;
            return bl5;
        }
        finally {
            if (bl2) {
                this.semaphore.release();
            }
        }
    }

    @Override
    public void updateData(Object object) {
        RollingFileManager$FactoryData rollingFileManager$FactoryData = (RollingFileManager$FactoryData)object;
        this.setRolloverStrategy(rollingFileManager$FactoryData.getRolloverStrategy());
        this.setTriggeringPolicy(rollingFileManager$FactoryData.getTriggeringPolicy());
    }

    static /* synthetic */ Semaphore access$100(RollingFileManager rollingFileManager) {
        return rollingFileManager.semaphore;
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1400() {
        return LOGGER;
    }
}

