/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="DefaultRolloverStrategy", category="Core", printObject=true)
public class DefaultRolloverStrategy
extends AbstractRolloverStrategy {
    private static final int MIN_WINDOW_SIZE = 1;
    private static final int DEFAULT_WINDOW_SIZE = 7;
    private final int maxIndex;
    private final int minIndex;
    private final boolean useMax;
    private final int compressionLevel;
    private final List<Action> customActions;
    private final boolean stopCustomActionsOnError;

    @PluginFactory
    public static DefaultRolloverStrategy createStrategy(@PluginAttribute(value="max") String string, @PluginAttribute(value="min") String string2, @PluginAttribute(value="fileIndex") String string3, @PluginAttribute(value="compressionLevel") String string4, @PluginElement(value="Actions") Action[] actionArray, @PluginAttribute(value="stopCustomActionsOnError", defaultBoolean=true) boolean bl2, @PluginConfiguration Configuration configuration) {
        boolean bl3;
        int n2;
        int n3;
        if (string3 != null && string3.equalsIgnoreCase("nomax")) {
            n3 = Integer.MIN_VALUE;
            n2 = Integer.MAX_VALUE;
            bl3 = false;
        } else {
            bl3 = string3 == null ? true : string3.equalsIgnoreCase("max");
            n3 = 1;
            if (string2 != null && (n3 = Integer.parseInt(string2)) < 1) {
                LOGGER.error("Minimum window size too small. Limited to 1");
                n3 = 1;
            }
            n2 = 7;
            if (string != null && (n2 = Integer.parseInt(string)) < n3) {
                n2 = n3 < 7 ? 7 : n3;
                LOGGER.error("Maximum window size must be greater than the minimum windows size. Set to " + n2);
            }
        }
        int n4 = Integers.parseInt(string4, -1);
        return new DefaultRolloverStrategy(n3, n2, bl3, n4, configuration.getStrSubstitutor(), actionArray, bl2);
    }

    protected DefaultRolloverStrategy(int n2, int n3, boolean bl2, int n4, StrSubstitutor strSubstitutor, Action[] actionArray, boolean bl3) {
        super(strSubstitutor);
        this.minIndex = n2;
        this.maxIndex = n3;
        this.useMax = bl2;
        this.compressionLevel = n4;
        this.stopCustomActionsOnError = bl3;
        this.customActions = actionArray == null ? Collections.emptyList() : Arrays.asList(actionArray);
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public List<Action> getCustomActions() {
        return this.customActions;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public boolean isUseMax() {
        return this.useMax;
    }

    private int purge(int n2, int n3, RollingFileManager rollingFileManager) {
        return this.useMax ? this.purgeAscending(n2, n3, rollingFileManager) : this.purgeDescending(n2, n3, rollingFileManager);
    }

    private int purgeAscending(int n2, int n3, RollingFileManager rollingFileManager) {
        Comparable<StringBuilder> comparable;
        SortedMap<Integer, Path> sortedMap = this.getEligibleFiles(rollingFileManager);
        int n4 = n3 - n2 + 1;
        boolean bl2 = false;
        while (sortedMap.size() >= n4) {
            try {
                LOGGER.debug("Eligible files: {}", (Object)sortedMap);
                comparable = sortedMap.firstKey();
                LOGGER.debug("Deleting {}", (Object)((Path)sortedMap.get(comparable)).toFile().getAbsolutePath());
                Files.delete((Path)sortedMap.get(comparable));
                sortedMap.remove(comparable);
                bl2 = true;
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to delete {}, {}", (Object)sortedMap.firstKey(), (Object)iOException.getMessage(), (Object)iOException);
                break;
            }
        }
        comparable = new StringBuilder();
        if (bl2) {
            for (Map.Entry<Integer, Path> entry : sortedMap.entrySet()) {
                ((StringBuilder)comparable).setLength(0);
                rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, (StringBuilder)comparable, (Object)(entry.getKey() - 1));
                String string = entry.getValue().toFile().getName();
                String string2 = ((StringBuilder)comparable).toString();
                int n5 = this.suffixLength(string2);
                if (n5 > 0 && this.suffixLength(string) == 0) {
                    string2 = string2.substring(0, string2.length() - n5);
                }
                FileRenameAction fileRenameAction = new FileRenameAction(entry.getValue().toFile(), new File(string2), true);
                try {
                    LOGGER.debug("DefaultRolloverStrategy.purgeAscending executing {}", (Object)fileRenameAction);
                    if (fileRenameAction.execute()) continue;
                    return -1;
                }
                catch (Exception exception) {
                    LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)exception);
                    return -1;
                }
            }
        }
        return sortedMap.size() > 0 ? (sortedMap.lastKey() < n3 ? sortedMap.lastKey() + 1 : n3) : n2;
    }

    private int purgeDescending(int n2, int n3, RollingFileManager rollingFileManager) {
        Comparable<StringBuilder> comparable;
        SortedMap<Integer, Path> sortedMap = this.getEligibleFiles(rollingFileManager, false);
        int n4 = n3 - n2 + 1;
        while (sortedMap.size() >= n4) {
            try {
                comparable = sortedMap.firstKey();
                Files.delete((Path)sortedMap.get(comparable));
                sortedMap.remove(comparable);
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to delete {}, {}", (Object)sortedMap.firstKey(), (Object)iOException.getMessage(), (Object)iOException);
                break;
            }
        }
        comparable = new StringBuilder();
        for (Map.Entry<Integer, Path> entry : sortedMap.entrySet()) {
            ((StringBuilder)comparable).setLength(0);
            rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, (StringBuilder)comparable, (Object)(entry.getKey() + 1));
            String string = entry.getValue().toFile().getName();
            String string2 = ((StringBuilder)comparable).toString();
            int n5 = this.suffixLength(string2);
            if (n5 > 0 && this.suffixLength(string) == 0) {
                string2 = string2.substring(0, string2.length() - n5);
            }
            FileRenameAction fileRenameAction = new FileRenameAction(entry.getValue().toFile(), new File(string2), true);
            try {
                LOGGER.debug("DefaultRolloverStrategy.purgeDescending executing {}", (Object)fileRenameAction);
                if (fileRenameAction.execute()) continue;
                return -1;
            }
            catch (Exception exception) {
                LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)exception);
                return -1;
            }
        }
        return n2;
    }

    @Override
    public RolloverDescription rollover(RollingFileManager rollingFileManager) {
        String string;
        int n2;
        SortedMap<Integer, Path> sortedMap;
        if (this.minIndex == Integer.MIN_VALUE) {
            sortedMap = this.getEligibleFiles(rollingFileManager);
            n2 = sortedMap.size() > 0 ? sortedMap.lastKey() + 1 : 1;
        } else {
            if (this.maxIndex < 0) {
                return null;
            }
            long l2 = System.nanoTime();
            n2 = this.purge(this.minIndex, this.maxIndex, rollingFileManager);
            if (n2 < 0) {
                return null;
            }
            if (LOGGER.isTraceEnabled()) {
                double d2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
                LOGGER.trace("DefaultRolloverStrategy.purge() took {} milliseconds", (Object)d2);
            }
        }
        sortedMap = new StringBuilder(255);
        rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, (StringBuilder)((Object)sortedMap), (Object)n2);
        String string2 = rollingFileManager.getFileName();
        String string3 = string = ((StringBuilder)((Object)sortedMap)).toString();
        Action action = null;
        FileExtension fileExtension = rollingFileManager.getFileExtension();
        if (fileExtension != null) {
            string = string.substring(0, string.length() - fileExtension.length());
            action = fileExtension.createCompressAction(string, string3, true, this.compressionLevel);
        }
        if (string2.equals(string)) {
            LOGGER.warn("Attempt to rename file {} to itself will be ignored", (Object)string2);
            return new RolloverDescriptionImpl(string2, false, null, null);
        }
        FileRenameAction fileRenameAction = new FileRenameAction(new File(string2), new File(string), rollingFileManager.isRenameEmptyFiles());
        Action action2 = this.merge(action, this.customActions, this.stopCustomActionsOnError);
        return new RolloverDescriptionImpl(string2, false, fileRenameAction, action2);
    }

    public String toString() {
        return "DefaultRolloverStrategy(min=" + this.minIndex + ", max=" + this.maxIndex + ", useMax=" + this.useMax + ")";
    }
}

