/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Policies", category="Core", printObject=true)
public final class CompositeTriggeringPolicy
extends AbstractTriggeringPolicy {
    private final TriggeringPolicy[] triggeringPolicies;

    private CompositeTriggeringPolicy(TriggeringPolicy ... triggeringPolicyArray) {
        this.triggeringPolicies = triggeringPolicyArray;
    }

    public TriggeringPolicy[] getTriggeringPolicies() {
        return this.triggeringPolicies;
    }

    @Override
    public void initialize(RollingFileManager rollingFileManager) {
        for (TriggeringPolicy triggeringPolicy : this.triggeringPolicies) {
            triggeringPolicy.initialize(rollingFileManager);
        }
    }

    @Override
    public boolean isTriggeringEvent(LogEvent logEvent) {
        for (TriggeringPolicy triggeringPolicy : this.triggeringPolicies) {
            if (!triggeringPolicy.isTriggeringEvent(logEvent)) continue;
            return true;
        }
        return false;
    }

    @PluginFactory
    public static CompositeTriggeringPolicy createPolicy(TriggeringPolicy ... triggeringPolicyArray) {
        return new CompositeTriggeringPolicy(triggeringPolicyArray);
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl2 = true;
        for (TriggeringPolicy triggeringPolicy : this.triggeringPolicies) {
            if (triggeringPolicy instanceof LifeCycle2) {
                bl2 &= ((LifeCycle2)((Object)triggeringPolicy)).stop(l2, timeUnit);
                continue;
            }
            if (!(triggeringPolicy instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)triggeringPolicy)).stop();
            bl2 &= true;
        }
        this.setStopped();
        return bl2;
    }

    public String toString() {
        return "CompositeTriggeringPolicy(policies=" + Arrays.toString(this.triggeringPolicies) + ")";
    }
}

