/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.MapRewritePolicy$Mode;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent$Builder;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="MapRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public final class MapRewritePolicy
implements RewritePolicy {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<String, String> map;
    private final MapRewritePolicy$Mode mode;

    private MapRewritePolicy(Map<String, String> map, MapRewritePolicy$Mode mapRewritePolicy$Mode) {
        this.map = map;
        this.mode = mapRewritePolicy$Mode;
    }

    @Override
    public LogEvent rewrite(LogEvent logEvent) {
        Map.Entry<String, String> entry2;
        Message message = logEvent.getMessage();
        if (message == null || !(message instanceof MapMessage)) {
            return logEvent;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(((MapMessage)message).getData());
        switch (this.mode) {
            case Add: {
                hashMap.putAll(this.map);
                break;
            }
            default: {
                for (Map.Entry<String, String> entry2 : this.map.entrySet()) {
                    if (!hashMap.containsKey(entry2.getKey())) continue;
                    hashMap.put((String)entry2.getKey(), (String)entry2.getValue());
                }
            }
        }
        MapMessage mapMessage = ((MapMessage)message).newInstance(hashMap);
        entry2 = new Log4jLogEvent$Builder(logEvent).setMessage(mapMessage).build();
        return entry2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mode=").append((Object)this.mode);
        stringBuilder.append(" {");
        boolean bl2 = true;
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
            bl2 = false;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @PluginFactory
    public static MapRewritePolicy createPolicy(@PluginAttribute(value="mode") String string, @PluginElement(value="KeyValuePair") KeyValuePair[] keyValuePairArray) {
        MapRewritePolicy$Mode mapRewritePolicy$Mode;
        MapRewritePolicy$Mode mapRewritePolicy$Mode2 = mapRewritePolicy$Mode = string == null ? (mapRewritePolicy$Mode = MapRewritePolicy$Mode.Add) : MapRewritePolicy$Mode.valueOf(string);
        if (keyValuePairArray == null || keyValuePairArray.length == 0) {
            LOGGER.error("keys and values must be specified for the MapRewritePolicy");
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (KeyValuePair keyValuePair : keyValuePairArray) {
            String string2 = keyValuePair.getKey();
            if (string2 == null) {
                LOGGER.error("A null key is not valid in MapRewritePolicy");
                continue;
            }
            String string3 = keyValuePair.getValue();
            if (string3 == null) {
                LOGGER.error("A null value for key " + string2 + " is not allowed in MapRewritePolicy");
                continue;
            }
            hashMap.put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        if (hashMap.isEmpty()) {
            LOGGER.error("MapRewritePolicy is not configured with any valid key value pairs");
            return null;
        }
        return new MapRewritePolicy(hashMap, mapRewritePolicy$Mode);
    }
}

