/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.mom.kafka.DefaultKafkaProducerFactory;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager$1;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager$2;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaProducerFactory;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.util.Log4jThread;

public class KafkaManager
extends AbstractManager {
    public static final String DEFAULT_TIMEOUT_MILLIS = "30000";
    static KafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory();
    private final Properties config = new Properties();
    private Producer<byte[], byte[]> producer;
    private final int timeoutMillis;
    private final String topic;
    private final boolean syncSend;

    public KafkaManager(LoggerContext loggerContext, String string, String string2, boolean bl2, Property[] propertyArray) {
        super(loggerContext, string);
        this.topic = Objects.requireNonNull(string2, "topic");
        this.syncSend = bl2;
        this.config.setProperty("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.config.setProperty("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.config.setProperty("batch.size", "0");
        for (Property property : propertyArray) {
            this.config.setProperty(property.getName(), property.getValue());
        }
        this.timeoutMillis = Integer.parseInt(this.config.getProperty("timeout.ms", DEFAULT_TIMEOUT_MILLIS));
    }

    @Override
    public boolean releaseSub(long l2, TimeUnit timeUnit) {
        if (l2 > 0L) {
            this.closeProducer(l2, timeUnit);
        } else {
            this.closeProducer(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    private void closeProducer(long l2, TimeUnit timeUnit) {
        if (this.producer != null) {
            Log4jThread log4jThread = new Log4jThread(new KafkaManager$1(this), "KafkaManager-CloseThread");
            log4jThread.setDaemon(true);
            log4jThread.start();
            try {
                log4jThread.join(timeUnit.toMillis(l2));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void send(byte[] byArray) {
        if (this.producer != null) {
            ProducerRecord producerRecord = new ProducerRecord(this.topic, (Object)byArray);
            if (this.syncSend) {
                Future future = this.producer.send(producerRecord);
                future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            } else {
                this.producer.send(producerRecord, (Callback)new KafkaManager$2(this));
            }
        }
    }

    public void startup() {
        this.producer = producerFactory.newKafkaProducer(this.config);
    }

    public String getTopic() {
        return this.topic;
    }

    static /* synthetic */ Producer access$000(KafkaManager kafkaManager) {
        return kafkaManager.producer;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

