/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaAppender$1;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaAppender$Builder;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.core.util.StringEncoder;

@Plugin(name="Kafka", category="Core", elementType="appender", printObject=true)
public final class KafkaAppender
extends AbstractAppender {
    private final KafkaManager manager;

    @Deprecated
    public static KafkaAppender createAppender(@PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @Required(message="No name provided for KafkaAppender") @PluginAttribute(value="name") String string, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean bl2, @Required(message="No topic provided for KafkaAppender") @PluginAttribute(value="topic") String string2, @PluginElement(value="Properties") Property[] propertyArray, @PluginConfiguration Configuration configuration) {
        KafkaManager kafkaManager = new KafkaManager(configuration.getLoggerContext(), string, string2, true, propertyArray);
        return new KafkaAppender(string, layout, filter, bl2, kafkaManager);
    }

    @PluginBuilderFactory
    public static <B extends KafkaAppender$Builder<B>> B newBuilder() {
        return (B)((KafkaAppender$Builder)new KafkaAppender$Builder().asBuilder());
    }

    private KafkaAppender(String string, Layout<? extends Serializable> layout, Filter filter, boolean bl2, KafkaManager kafkaManager) {
        super(string, filter, layout, bl2);
        this.manager = Objects.requireNonNull(kafkaManager, "manager");
    }

    @Override
    public void append(LogEvent logEvent) {
        if (logEvent.getLoggerName().startsWith("org.apache.kafka")) {
            LOGGER.warn("Recursive logging from [{}] for appender [{}].", (Object)logEvent.getLoggerName(), (Object)this.getName());
        } else {
            try {
                byte[] byArray;
                Layout<? extends Serializable> layout = this.getLayout();
                if (layout != null) {
                    if (layout instanceof SerializedLayout) {
                        byte[] byArray2 = layout.getHeader();
                        byte[] byArray3 = layout.toByteArray(logEvent);
                        byArray = new byte[byArray2.length + byArray3.length];
                        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                        System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
                    } else {
                        byArray = layout.toByteArray(logEvent);
                    }
                } else {
                    byArray = StringEncoder.toBytes(logEvent.getMessage().getFormattedMessage(), StandardCharsets.UTF_8);
                }
                this.manager.send(byArray);
            }
            catch (Exception exception) {
                LOGGER.error("Unable to write to Kafka [{}] for appender [{}].", (Object)this.manager.getName(), (Object)this.getName(), (Object)exception);
                throw new AppenderLoggingException("Unable to write to Kafka in appender: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.manager.startup();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl2 = super.stop(l2, timeUnit, false);
        this.setStopped();
        return bl2 &= this.manager.stop(l2, timeUnit);
    }

    @Override
    public String toString() {
        return "KafkaAppender{name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + ", topic=" + this.manager.getTopic() + '}';
    }

    /* synthetic */ KafkaAppender(String string, Layout layout, Filter filter, boolean bl2, KafkaManager kafkaManager, KafkaAppender$1 kafkaAppender$1) {
        this(string, layout, filter, bl2, kafkaManager);
    }
}

