/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.mom.JmsManager$JmsConfiguration;
import org.apache.logging.log4j.core.appender.mom.JmsManager$JmsManagerFactory;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.status.StatusLogger;

public class JmsManager
extends AbstractManager {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final JmsManager$JmsManagerFactory FACTORY = new JmsManager$JmsManagerFactory();
    private final JndiManager jndiManager;
    private final Connection connection;
    private final Session session;
    private final Destination destination;

    private JmsManager(String string, JndiManager jndiManager, String string2, String string3, String string4, String string5) {
        super(null, string);
        this.jndiManager = jndiManager;
        ConnectionFactory connectionFactory = (ConnectionFactory)this.jndiManager.lookup(string2);
        this.connection = string4 != null && string5 != null ? connectionFactory.createConnection(string4, string5) : connectionFactory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.destination = (Destination)this.jndiManager.lookup(string3);
        this.connection.start();
    }

    public static JmsManager getJmsManager(String string, JndiManager jndiManager, String string2, String string3, String string4, String string5) {
        JmsManager$JmsConfiguration jmsManager$JmsConfiguration = new JmsManager$JmsConfiguration(jndiManager, string2, string3, string4, string5);
        return JmsManager.getManager(string, FACTORY, jmsManager$JmsConfiguration);
    }

    public MessageConsumer createMessageConsumer() {
        return this.session.createConsumer(this.destination);
    }

    public MessageProducer createMessageProducer() {
        return this.session.createProducer(this.destination);
    }

    public Message createMessage(Serializable serializable) {
        if (serializable instanceof String) {
            return this.session.createTextMessage((String)((Object)serializable));
        }
        return this.session.createObjectMessage(serializable);
    }

    @Override
    protected boolean releaseSub(long l2, TimeUnit timeUnit) {
        boolean bl2 = true;
        try {
            this.session.close();
        }
        catch (JMSException jMSException) {
            bl2 = false;
        }
        try {
            this.connection.close();
        }
        catch (JMSException jMSException) {
            bl2 = false;
        }
        return bl2 && this.jndiManager.stop(l2, timeUnit);
    }

    static /* synthetic */ Logger access$800() {
        return LOGGER;
    }
}

