/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.mom.JmsAppender$Builder;
import org.apache.logging.log4j.core.appender.mom.JmsManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="JMS", category="Core", elementType="appender", printObject=true)
@PluginAliases(value={"JMSQueue", "JMSTopic"})
public class JmsAppender
extends AbstractAppender {
    private final JmsManager manager;
    private final MessageProducer producer;

    protected JmsAppender(String string, Filter filter, Layout<? extends Serializable> layout, boolean bl2, JmsManager jmsManager) {
        super(string, filter, layout, bl2);
        this.manager = jmsManager;
        this.producer = this.manager.createMessageProducer();
    }

    @Override
    public void append(LogEvent logEvent) {
        try {
            Message message = this.manager.createMessage(this.getLayout().toSerializable(logEvent));
            message.setJMSTimestamp(logEvent.getTimeMillis());
            this.producer.send(message);
        }
        catch (JMSException jMSException) {
            throw new AppenderLoggingException(jMSException);
        }
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl2 = super.stop(l2, timeUnit, false);
        this.setStopped();
        return bl2 &= this.manager.stop(l2, timeUnit);
    }

    @PluginBuilderFactory
    public static JmsAppender$Builder newBuilder() {
        return new JmsAppender$Builder(null);
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

