/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom;

import java.io.Serializable;
import javax.jms.JMSException;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.mom.JmsAppender;
import org.apache.logging.log4j.core.appender.mom.JmsManager;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.core.util.Builder;

public class JmsAppender$Builder
implements Builder<JmsAppender> {
    @PluginBuilderAttribute
    @Required(message="A name for the JmsAppender must be specified")
    private String name;
    @PluginBuilderAttribute
    private String factoryName;
    @PluginBuilderAttribute
    private String providerUrl;
    @PluginBuilderAttribute
    private String urlPkgPrefixes;
    @PluginBuilderAttribute
    private String securityPrincipalName;
    @PluginBuilderAttribute(sensitive=true)
    private String securityCredentials;
    @PluginBuilderAttribute
    @Required(message="A javax.jms.ConnectionFactory JNDI name must be specified")
    private String factoryBindingName;
    @PluginBuilderAttribute
    @PluginAliases(value={"queueBindingName", "topicBindingName"})
    @Required(message="A javax.jms.Destination JNDI name must be specified")
    private String destinationBindingName;
    @PluginBuilderAttribute
    private String username;
    @PluginBuilderAttribute(sensitive=true)
    private String password;
    @PluginElement(value="Layout")
    private Layout<? extends Serializable> layout = SerializedLayout.createLayout();
    @PluginElement(value="Filter")
    private Filter filter;
    @PluginBuilderAttribute
    private boolean ignoreExceptions = true;
    private JmsManager jmsManager;

    private JmsAppender$Builder() {
    }

    public JmsAppender$Builder setName(String string) {
        this.name = string;
        return this;
    }

    public JmsAppender$Builder setFactoryName(String string) {
        this.factoryName = string;
        return this;
    }

    public JmsAppender$Builder setProviderUrl(String string) {
        this.providerUrl = string;
        return this;
    }

    public JmsAppender$Builder setUrlPkgPrefixes(String string) {
        this.urlPkgPrefixes = string;
        return this;
    }

    public JmsAppender$Builder setSecurityPrincipalName(String string) {
        this.securityPrincipalName = string;
        return this;
    }

    public JmsAppender$Builder setSecurityCredentials(String string) {
        this.securityCredentials = string;
        return this;
    }

    public JmsAppender$Builder setFactoryBindingName(String string) {
        this.factoryBindingName = string;
        return this;
    }

    public JmsAppender$Builder setDestinationBindingName(String string) {
        this.destinationBindingName = string;
        return this;
    }

    public JmsAppender$Builder setUsername(String string) {
        this.username = string;
        return this;
    }

    public JmsAppender$Builder setPassword(String string) {
        this.password = string;
        return this;
    }

    public JmsAppender$Builder setLayout(Layout<? extends Serializable> layout) {
        this.layout = layout;
        return this;
    }

    public JmsAppender$Builder setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public JmsAppender$Builder setJmsManager(JmsManager jmsManager) {
        this.jmsManager = jmsManager;
        return this;
    }

    public JmsAppender$Builder setIgnoreExceptions(boolean bl2) {
        this.ignoreExceptions = bl2;
        return this;
    }

    @Override
    public JmsAppender build() {
        JmsManager jmsManager = this.jmsManager;
        if (jmsManager == null) {
            JndiManager jndiManager = JndiManager.getJndiManager(this.factoryName, this.providerUrl, this.urlPkgPrefixes, this.securityPrincipalName, this.securityCredentials, null);
            jmsManager = JmsManager.getJmsManager(this.name, jndiManager, this.factoryBindingName, this.destinationBindingName, this.username, this.password);
        }
        try {
            return new JmsAppender(this.name, this.filter, this.layout, this.ignoreExceptions, jmsManager);
        }
        catch (JMSException jMSException) {
            JmsAppender.access$100().error("Error creating JmsAppender [{}].", (Object)this.name, (Object)jMSException);
            return null;
        }
    }
}

