/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jpa.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.persistence.PersistenceException;
import org.apache.logging.log4j.core.appender.db.jpa.converter.ContextDataJsonAttributeConverter$1;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Strings;

@Converter(autoApply=false)
public class ContextDataJsonAttributeConverter
implements AttributeConverter<ReadOnlyStringMap, String> {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public String convertToDatabaseColumn(ReadOnlyStringMap readOnlyStringMap) {
        if (readOnlyStringMap == null) {
            return null;
        }
        try {
            JsonNodeFactory jsonNodeFactory = OBJECT_MAPPER.getNodeFactory();
            ObjectNode objectNode = jsonNodeFactory.objectNode();
            readOnlyStringMap.forEach(new ContextDataJsonAttributeConverter$1(this, objectNode));
            return OBJECT_MAPPER.writeValueAsString((Object)objectNode);
        }
        catch (Exception exception) {
            throw new PersistenceException("Failed to convert contextData to JSON string.", (Throwable)exception);
        }
    }

    public ReadOnlyStringMap convertToEntityAttribute(String string) {
        if (Strings.isEmpty(string)) {
            return null;
        }
        try {
            StringMap stringMap = ContextDataFactory.createContextData();
            ObjectNode objectNode = (ObjectNode)OBJECT_MAPPER.readTree(string);
            Iterator iterator = objectNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string2 = ((JsonNode)entry.getValue()).textValue();
                stringMap.putValue((String)entry.getKey(), string2);
            }
            return stringMap;
        }
        catch (IOException iOException) {
            throw new PersistenceException("Failed to convert JSON string to map.", (Throwable)iOException);
        }
    }
}

