/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jpa;

import java.lang.reflect.Constructor;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.db.jpa.AbstractLogEventWrapperEntity;
import org.apache.logging.log4j.core.appender.db.jpa.JpaDatabaseManager$FactoryData;
import org.apache.logging.log4j.core.appender.db.jpa.JpaDatabaseManager$JPADatabaseManagerFactory;

public final class JpaDatabaseManager
extends AbstractDatabaseManager {
    private static final JpaDatabaseManager$JPADatabaseManagerFactory FACTORY = new JpaDatabaseManager$JPADatabaseManagerFactory(null);
    private final String entityClassName;
    private final Constructor<? extends AbstractLogEventWrapperEntity> entityConstructor;
    private final String persistenceUnitName;
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private EntityTransaction transaction;

    private JpaDatabaseManager(String string, int n2, Class<? extends AbstractLogEventWrapperEntity> clazz, Constructor<? extends AbstractLogEventWrapperEntity> constructor, String string2) {
        super(string, n2);
        this.entityClassName = clazz.getName();
        this.entityConstructor = constructor;
        this.persistenceUnitName = string2;
    }

    @Override
    protected void startupInternal() {
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
    }

    @Override
    protected boolean shutdownInternal() {
        boolean bl2 = true;
        if (this.entityManager != null || this.transaction != null) {
            bl2 &= this.commitAndClose();
        }
        if (this.entityManagerFactory != null && this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
        return bl2;
    }

    @Override
    protected void connectAndStart() {
        try {
            this.entityManager = this.entityManagerFactory.createEntityManager();
            this.transaction = this.entityManager.getTransaction();
            this.transaction.begin();
        }
        catch (Exception exception) {
            throw new AppenderLoggingException("Cannot write logging event or flush buffer; manager cannot create EntityManager or transaction.", exception);
        }
    }

    @Override
    protected void writeInternal(LogEvent logEvent) {
        AbstractLogEventWrapperEntity abstractLogEventWrapperEntity;
        if (!this.isRunning() || this.entityManagerFactory == null || this.entityManager == null || this.transaction == null) {
            throw new AppenderLoggingException("Cannot write logging event; JPA manager not connected to the database.");
        }
        try {
            abstractLogEventWrapperEntity = this.entityConstructor.newInstance(logEvent);
        }
        catch (Exception exception) {
            throw new AppenderLoggingException("Failed to instantiate entity class [" + this.entityClassName + "].", exception);
        }
        try {
            this.entityManager.persist((Object)abstractLogEventWrapperEntity);
        }
        catch (Exception exception) {
            if (this.transaction != null && this.transaction.isActive()) {
                this.transaction.rollback();
                this.transaction = null;
            }
            throw new AppenderLoggingException("Failed to insert record for log event in JPA manager: " + exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean commitAndClose() {
        boolean bl2 = true;
        try {
            if (this.transaction == null) return bl2;
            if (!this.transaction.isActive()) return bl2;
            this.transaction.commit();
            return bl2;
        }
        catch (Exception exception) {
            if (this.transaction == null) return bl2;
            if (!this.transaction.isActive()) return bl2;
            this.transaction.rollback();
            return bl2;
        }
        finally {
            this.transaction = null;
            try {
                if (this.entityManager != null && this.entityManager.isOpen()) {
                    this.entityManager.close();
                }
            }
            catch (Exception exception) {
                this.logWarn("Failed to close entity manager while logging event or flushing buffer", exception);
                bl2 = false;
            }
            finally {
                this.entityManager = null;
            }
        }
    }

    public static JpaDatabaseManager getJPADatabaseManager(String string, int n2, Class<? extends AbstractLogEventWrapperEntity> clazz, Constructor<? extends AbstractLogEventWrapperEntity> constructor, String string2) {
        return AbstractDatabaseManager.getManager(string, new JpaDatabaseManager$FactoryData(n2, clazz, constructor, string2), FACTORY);
    }
}

