/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager$1;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager$FactoryData;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager$JdbcDatabaseManagerFactory;
import org.apache.logging.log4j.core.config.plugins.convert.DateTypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

public final class JdbcDatabaseManager
extends AbstractDatabaseManager {
    private static final JdbcDatabaseManager$JdbcDatabaseManagerFactory INSTANCE = new JdbcDatabaseManager$JdbcDatabaseManagerFactory(null);
    private final List<ColumnMapping> columnMappings;
    private final List<ColumnConfig> columnConfigs;
    private final ConnectionSource connectionSource;
    private final String sqlStatement;
    private Connection connection;
    private PreparedStatement statement;
    private boolean isBatchSupported;

    private JdbcDatabaseManager(String string, int n2, ConnectionSource connectionSource, String string2, List<ColumnConfig> list, List<ColumnMapping> list2) {
        super(string, n2);
        this.connectionSource = connectionSource;
        this.sqlStatement = string2;
        this.columnConfigs = list;
        this.columnMappings = list2;
    }

    @Override
    protected void startupInternal() {
        this.connection = this.connectionSource.getConnection();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.isBatchSupported = databaseMetaData.supportsBatchUpdates();
        Closer.closeSilently(this.connection);
    }

    @Override
    protected boolean shutdownInternal() {
        if (this.connection != null || this.statement != null) {
            return this.commitAndClose();
        }
        return true;
    }

    @Override
    protected void connectAndStart() {
        try {
            this.connection = this.connectionSource.getConnection();
            this.connection.setAutoCommit(false);
            this.statement = this.connection.prepareStatement(this.sqlStatement);
        }
        catch (SQLException sQLException) {
            throw new AppenderLoggingException("Cannot write logging event or flush buffer; JDBC manager cannot connect to the database.", sQLException);
        }
    }

    @Override
    protected void writeInternal(LogEvent logEvent) {
        StringReader stringReader = null;
        try {
            if (!this.isRunning() || this.connection == null || this.connection.isClosed() || this.statement == null || this.statement.isClosed()) {
                throw new AppenderLoggingException("Cannot write logging event; JDBC manager not connected to the database.");
            }
            int n2 = 1;
            for (ColumnMapping object : this.columnMappings) {
                if (ThreadContextMap.class.isAssignableFrom(object.getType()) || ReadOnlyStringMap.class.isAssignableFrom(object.getType())) {
                    this.statement.setObject(n2++, logEvent.getContextData().toMap());
                    continue;
                }
                if (ThreadContextStack.class.isAssignableFrom(object.getType())) {
                    this.statement.setObject(n2++, logEvent.getContextStack().asList());
                    continue;
                }
                if (Date.class.isAssignableFrom(object.getType())) {
                    this.statement.setObject(n2++, DateTypeConverter.fromMillis(logEvent.getTimeMillis(), object.getType().asSubclass(Date.class)));
                    continue;
                }
                if (Clob.class.isAssignableFrom(object.getType())) {
                    this.statement.setClob(n2++, new StringReader((String)object.getLayout().toSerializable(logEvent)));
                    continue;
                }
                if (NClob.class.isAssignableFrom(object.getType())) {
                    this.statement.setNClob(n2++, new StringReader((String)object.getLayout().toSerializable(logEvent)));
                    continue;
                }
                Object obj = TypeConverters.convert((String)object.getLayout().toSerializable(logEvent), object.getType(), null);
                if (obj == null) {
                    this.statement.setNull(n2++, 0);
                    continue;
                }
                this.statement.setObject(n2++, obj);
            }
            for (ColumnConfig columnConfig : this.columnConfigs) {
                if (columnConfig.isEventTimestamp()) {
                    this.statement.setTimestamp(n2++, new Timestamp(logEvent.getTimeMillis()));
                    continue;
                }
                if (columnConfig.isClob()) {
                    stringReader = new StringReader(columnConfig.getLayout().toSerializable(logEvent));
                    if (columnConfig.isUnicode()) {
                        this.statement.setNClob(n2++, stringReader);
                        continue;
                    }
                    this.statement.setClob(n2++, stringReader);
                    continue;
                }
                if (columnConfig.isUnicode()) {
                    this.statement.setNString(n2++, columnConfig.getLayout().toSerializable(logEvent));
                    continue;
                }
                this.statement.setString(n2++, columnConfig.getLayout().toSerializable(logEvent));
            }
            if (this.isBatchSupported) {
                this.statement.addBatch();
            } else if (this.statement.executeUpdate() == 0) {
                throw new AppenderLoggingException("No records inserted in database table for log event in JDBC manager.");
            }
        }
        catch (SQLException sQLException) {
            throw new AppenderLoggingException("Failed to insert record for log event in JDBC manager: " + sQLException.getMessage(), sQLException);
        }
        finally {
            Closer.closeSilently(stringReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean commitAndClose() {
        boolean bl2 = true;
        try {
            if (this.connection == null) return bl2;
            if (this.connection.isClosed()) return bl2;
            if (this.isBatchSupported) {
                this.statement.executeBatch();
            }
            this.connection.commit();
            return bl2;
        }
        catch (SQLException sQLException) {
            throw new AppenderLoggingException("Failed to commit transaction logging event or flushing buffer.", sQLException);
        }
        finally {
            try {
                Closer.close(this.statement);
            }
            catch (Exception exception) {
                this.logWarn("Failed to close SQL statement logging event or flushing buffer", exception);
                bl2 = false;
            }
            finally {
                this.statement = null;
            }
            try {
                Closer.close(this.connection);
            }
            catch (Exception exception) {
                this.logWarn("Failed to close database connection logging event or flushing buffer", exception);
                bl2 = false;
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Deprecated
    public static JdbcDatabaseManager getJDBCDatabaseManager(String string, int n2, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray) {
        return JdbcDatabaseManager.getManager(string, new JdbcDatabaseManager$FactoryData(n2, connectionSource, string2, columnConfigArray, new ColumnMapping[0]), JdbcDatabaseManager.getFactory());
    }

    public static JdbcDatabaseManager getManager(String string, int n2, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray, ColumnMapping[] columnMappingArray) {
        return JdbcDatabaseManager.getManager(string, new JdbcDatabaseManager$FactoryData(n2, connectionSource, string2, columnConfigArray, columnMappingArray), JdbcDatabaseManager.getFactory());
    }

    private static JdbcDatabaseManager$JdbcDatabaseManagerFactory getFactory() {
        return INSTANCE;
    }

    /* synthetic */ JdbcDatabaseManager(String string, int n2, ConnectionSource connectionSource, String string2, List list, List list2, JdbcDatabaseManager$1 jdbcDatabaseManager$1) {
        this(string, n2, connectionSource, string2, list, list2);
    }
}

