/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender$Builder;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcAppender;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Assert;
import org.apache.logging.log4j.core.util.Builder;

public class JdbcAppender$Builder<B extends JdbcAppender$Builder<B>>
extends AbstractAppender$Builder<B>
implements Builder<JdbcAppender> {
    @PluginElement(value="ConnectionSource")
    @Required(message="No ConnectionSource provided")
    private ConnectionSource connectionSource;
    @PluginBuilderAttribute
    private int bufferSize;
    @PluginBuilderAttribute
    @Required(message="No table name provided")
    private String tableName;
    @PluginElement(value="ColumnConfigs")
    private ColumnConfig[] columnConfigs;
    @PluginElement(value="ColumnMappings")
    private ColumnMapping[] columnMappings;

    public B setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public B setBufferSize(int n2) {
        this.bufferSize = n2;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public B setTableName(String string) {
        this.tableName = string;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public B setColumnConfigs(ColumnConfig ... columnConfigArray) {
        this.columnConfigs = columnConfigArray;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public B setColumnMappings(ColumnMapping ... columnMappingArray) {
        this.columnMappings = columnMappingArray;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    @Override
    public JdbcAppender build() {
        if (Assert.isEmpty(this.columnConfigs) && Assert.isEmpty(this.columnMappings)) {
            JdbcAppender.access$000().error("Cannot create JdbcAppender without any columns configured.");
            return null;
        }
        String string = "JdbcManager{name=" + this.getName() + ", bufferSize=" + this.bufferSize + ", tableName=" + this.tableName + ", columnConfigs=" + Arrays.toString(this.columnConfigs) + ", columnMappings=" + Arrays.toString(this.columnMappings) + '}';
        JdbcDatabaseManager jdbcDatabaseManager = JdbcDatabaseManager.getManager(string, this.bufferSize, this.connectionSource, this.tableName, this.columnConfigs, this.columnMappings);
        if (jdbcDatabaseManager == null) {
            return null;
        }
        return new JdbcAppender(this.getName(), this.getFilter(), this.isIgnoreExceptions(), jdbcDatabaseManager);
    }

    @Override
    @Deprecated
    public Layout<? extends Serializable> getLayout() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public B withLayout(Layout<? extends Serializable> layout) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Layout<? extends Serializable> getOrCreateLayout() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Layout<? extends Serializable> getOrCreateLayout(Charset charset) {
        throw new UnsupportedOperationException();
    }
}

