/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig$Builder;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="Column", category="Core", printObject=true)
public final class ColumnConfig {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String columnName;
    private final PatternLayout layout;
    private final String literalValue;
    private final boolean eventTimestamp;
    private final boolean unicode;
    private final boolean clob;

    private ColumnConfig(String string, PatternLayout patternLayout, String string2, boolean bl2, boolean bl3, boolean bl4) {
        this.columnName = string;
        this.layout = patternLayout;
        this.literalValue = string2;
        this.eventTimestamp = bl2;
        this.unicode = bl3;
        this.clob = bl4;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public PatternLayout getLayout() {
        return this.layout;
    }

    public String getLiteralValue() {
        return this.literalValue;
    }

    public boolean isEventTimestamp() {
        return this.eventTimestamp;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public boolean isClob() {
        return this.clob;
    }

    public String toString() {
        return "{ name=" + this.columnName + ", layout=" + this.layout + ", literal=" + this.literalValue + ", timestamp=" + this.eventTimestamp + " }";
    }

    @Deprecated
    public static ColumnConfig createColumnConfig(Configuration configuration, String string, String string2, String string3, String string4, String string5, String string6) {
        if (Strings.isEmpty(string)) {
            LOGGER.error("The column config is not valid because it does not contain a column name.");
            return null;
        }
        boolean bl2 = Boolean.parseBoolean(string4);
        boolean bl3 = Booleans.parseBoolean(string5, true);
        boolean bl4 = Boolean.parseBoolean(string6);
        return ColumnConfig.newBuilder().setConfiguration(configuration).setName(string).setPattern(string2).setLiteral(string3).setEventTimestamp(bl2).setUnicode(bl3).setClob(bl4).build();
    }

    @PluginBuilderFactory
    public static ColumnConfig$Builder newBuilder() {
        return new ColumnConfig$Builder();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

