/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.util.Strings;

public class ColumnConfig$Builder
implements Builder<ColumnConfig> {
    @PluginConfiguration
    private Configuration configuration;
    @PluginBuilderAttribute
    @Required(message="No name provided")
    private String name;
    @PluginBuilderAttribute
    private String pattern;
    @PluginBuilderAttribute
    private String literal;
    @PluginBuilderAttribute
    private boolean isEventTimestamp;
    @PluginBuilderAttribute
    private boolean isUnicode = true;
    @PluginBuilderAttribute
    private boolean isClob;

    public ColumnConfig$Builder setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ColumnConfig$Builder setName(String string) {
        this.name = string;
        return this;
    }

    public ColumnConfig$Builder setPattern(String string) {
        this.pattern = string;
        return this;
    }

    public ColumnConfig$Builder setLiteral(String string) {
        this.literal = string;
        return this;
    }

    public ColumnConfig$Builder setEventTimestamp(boolean bl2) {
        this.isEventTimestamp = bl2;
        return this;
    }

    public ColumnConfig$Builder setUnicode(boolean bl2) {
        this.isUnicode = bl2;
        return this;
    }

    public ColumnConfig$Builder setClob(boolean bl2) {
        this.isClob = bl2;
        return this;
    }

    @Override
    public ColumnConfig build() {
        if (Strings.isEmpty(this.name)) {
            ColumnConfig.access$000().error("The column config is not valid because it does not contain a column name.");
            return null;
        }
        boolean bl2 = Strings.isNotEmpty(this.pattern);
        boolean bl3 = Strings.isNotEmpty(this.literal);
        if (bl2 && bl3 || bl2 && this.isEventTimestamp || bl3 && this.isEventTimestamp) {
            ColumnConfig.access$000().error("The pattern, literal, and isEventTimestamp attributes are mutually exclusive.");
            return null;
        }
        if (this.isEventTimestamp) {
            return new ColumnConfig(this.name, null, null, true, false, false, null);
        }
        if (bl3) {
            return new ColumnConfig(this.name, null, this.literal, false, false, false, null);
        }
        if (bl2) {
            PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(this.pattern).withConfiguration(this.configuration).withAlwaysWriteExceptions(false).build();
            return new ColumnConfig(this.name, patternLayout, null, false, this.isUnicode, this.isClob, null);
        }
        ColumnConfig.access$000().error("To configure a column you must specify a pattern or literal or set isEventDate to true.");
        return null;
    }
}

