/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.SocketAppender$Builder;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.net.DatagramSocketManager;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.SslSocketManager;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Socket", category="Core", elementType="appender", printObject=true)
public class SocketAppender
extends AbstractOutputStreamAppender<AbstractSocketManager> {
    private final Object advertisement;
    private final Advertiser advertiser;

    @PluginBuilderFactory
    public static SocketAppender$Builder newBuilder() {
        return new SocketAppender$Builder();
    }

    protected SocketAppender(String string, Layout<? extends Serializable> layout, Filter filter, AbstractSocketManager abstractSocketManager, boolean bl2, boolean bl3, Advertiser advertiser) {
        super(string, layout, filter, bl2, bl3, abstractSocketManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.putAll(abstractSocketManager.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        } else {
            this.advertisement = null;
        }
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    @Deprecated
    @PluginFactory
    public static SocketAppender createAppender(String string, int n2, Protocol protocol, SslConfiguration sslConfiguration, int n3, int n4, boolean bl2, String string2, boolean bl3, boolean bl4, Layout<? extends Serializable> layout, Filter filter, boolean bl5, Configuration configuration) {
        return ((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)SocketAppender.newBuilder().withAdvertise(bl5)).setConfiguration(configuration)).withConnectTimeoutMillis(n3)).withFilter(filter)).withHost(string)).withIgnoreExceptions(bl4)).withImmediateFail(bl2)).withLayout(layout)).withName(string2)).withPort(n2)).withProtocol(protocol)).withReconnectDelayMillis(n4)).withSslConfiguration(sslConfiguration)).build();
    }

    @Deprecated
    public static SocketAppender createAppender(String string, String string2, String string3, SslConfiguration sslConfiguration, int n2, String string4, String string5, String string6, String string7, String string8, Layout<? extends Serializable> layout, Filter filter, String string9, Configuration configuration) {
        boolean bl2 = Booleans.parseBoolean(string7, true);
        boolean bl3 = Boolean.parseBoolean(string9);
        boolean bl4 = Booleans.parseBoolean(string8, true);
        boolean bl5 = Booleans.parseBoolean(string5, true);
        int n3 = AbstractAppender.parseInt(string4, 0);
        int n4 = AbstractAppender.parseInt(string2, 0);
        Protocol protocol = string3 == null ? Protocol.UDP : Protocol.valueOf(string3);
        return SocketAppender.createAppender(string, n4, protocol, sslConfiguration, n2, n3, bl5, string6, bl2, bl4, layout, filter, bl3, configuration);
    }

    @Deprecated
    protected static AbstractSocketManager createSocketManager(String string, Protocol protocol, String string2, int n2, int n3, SslConfiguration sslConfiguration, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        return SocketAppender.createSocketManager(string, protocol, string2, n2, n3, sslConfiguration, n4, bl2, layout, n5, null);
    }

    protected static AbstractSocketManager createSocketManager(String string, Protocol protocol, String string2, int n2, int n3, SslConfiguration sslConfiguration, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        if (protocol == Protocol.TCP && sslConfiguration != null) {
            protocol = Protocol.SSL;
        }
        if (protocol != Protocol.SSL && sslConfiguration != null) {
            LOGGER.info("Appender {} ignoring SSL configuration for {} protocol", (Object)string, (Object)protocol);
        }
        switch (protocol) {
            case TCP: {
                return TcpSocketManager.getSocketManager(string2, n2, n3, n4, bl2, layout, n5, socketOptions);
            }
            case UDP: {
                return DatagramSocketManager.getSocketManager(string2, n2, layout, n5);
            }
            case SSL: {
                return SslSocketManager.getSocketManager(sslConfiguration, string2, n2, n3, n4, bl2, layout, n5, socketOptions);
            }
        }
        throw new IllegalArgumentException(protocol.toString());
    }

    @Override
    protected void directEncodeEvent(LogEvent logEvent) {
        this.writeByteArrayToManager(logEvent);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

