/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender$Builder;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable$Builder;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="RollingRandomAccessFile", category="Core", elementType="appender", printObject=true)
public final class RollingRandomAccessFileAppender
extends AbstractOutputStreamAppender<RollingRandomAccessFileManager> {
    private final String fileName;
    private final String filePattern;
    private final Object advertisement;
    private final Advertiser advertiser;

    private RollingRandomAccessFileAppender(String string, Layout<? extends Serializable> layout, Filter filter, RollingRandomAccessFileManager rollingRandomAccessFileManager, String string2, String string3, boolean bl2, boolean bl3, int n2, Advertiser advertiser) {
        super(string, layout, filter, bl2, bl3, rollingRandomAccessFileManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        } else {
            this.advertisement = null;
        }
        this.fileName = string2;
        this.filePattern = string3;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    @Override
    public void append(LogEvent logEvent) {
        RollingRandomAccessFileManager rollingRandomAccessFileManager = (RollingRandomAccessFileManager)this.getManager();
        rollingRandomAccessFileManager.checkRollover(logEvent);
        rollingRandomAccessFileManager.setEndOfBatch(logEvent.isEndOfBatch());
        super.append(logEvent);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public int getBufferSize() {
        return ((RollingRandomAccessFileManager)this.getManager()).getBufferSize();
    }

    @Deprecated
    public static <B extends RollingRandomAccessFileAppender$Builder<B>> RollingRandomAccessFileAppender createAppender(String string, String string2, String string3, String string4, String string5, String string6, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, Layout<? extends Serializable> layout, Filter filter, String string7, String string8, String string9, Configuration configuration) {
        boolean bl2 = Booleans.parseBoolean(string3, true);
        boolean bl3 = Booleans.parseBoolean(string7, true);
        boolean bl4 = Booleans.parseBoolean(string5, true);
        boolean bl5 = Boolean.parseBoolean(string8);
        int n2 = Integers.parseInt(string6, 262144);
        return ((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((AbstractFilterable$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((AbstractOutputStreamAppender$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)((RollingRandomAccessFileAppender$Builder)RollingRandomAccessFileAppender.newBuilder()).withAdvertise(bl5)).withAdvertiseURI(string9)).withAppend(bl2)).withBufferSize(n2)).setConfiguration(configuration)).withFileName(string)).withFilePattern(string2)).withFilter(filter)).withIgnoreExceptions(bl3)).withImmediateFlush(bl4)).withLayout(layout)).withName(string4)).withPolicy(triggeringPolicy)).withStrategy(rolloverStrategy)).build();
    }

    @PluginBuilderFactory
    public static <B extends RollingRandomAccessFileAppender$Builder<B>> B newBuilder() {
        return (B)((RollingRandomAccessFileAppender$Builder)new RollingRandomAccessFileAppender$Builder().asBuilder());
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }
}

