/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender$Builder;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.RollingFileAppender$Builder;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable$Builder;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="RollingFile", category="Core", elementType="appender", printObject=true)
public final class RollingFileAppender
extends AbstractOutputStreamAppender<RollingFileManager> {
    public static final String PLUGIN_NAME = "RollingFile";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final String fileName;
    private final String filePattern;
    private Object advertisement;
    private final Advertiser advertiser;

    private RollingFileAppender(String string, Layout<? extends Serializable> layout, Filter filter, RollingFileManager rollingFileManager, String string2, String string3, boolean bl2, boolean bl3, Advertiser advertiser) {
        super(string, layout, filter, bl2, bl3, rollingFileManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        }
        this.fileName = string2;
        this.filePattern = string3;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl2 = super.stop(l2, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return bl2;
    }

    @Override
    public void append(LogEvent logEvent) {
        ((RollingFileManager)this.getManager()).checkRollover(logEvent);
        super.append(logEvent);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public <T extends TriggeringPolicy> T getTriggeringPolicy() {
        return ((RollingFileManager)this.getManager()).getTriggeringPolicy();
    }

    @Deprecated
    public static <B extends RollingFileAppender$Builder<B>> RollingFileAppender createAppender(String string, String string2, String string3, String string4, String string5, String string6, String string7, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, Layout<? extends Serializable> layout, Filter filter, String string8, String string9, String string10, Configuration configuration) {
        int n2 = Integers.parseInt(string6, 8192);
        return ((RollingFileAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((AbstractAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((AbstractFilterable$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((AbstractOutputStreamAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)((RollingFileAppender$Builder)RollingFileAppender.newBuilder()).withAdvertise(Boolean.parseBoolean(string9))).withAdvertiseUri(string10)).withAppend(Booleans.parseBoolean(string3, true))).withBufferedIo(Booleans.parseBoolean(string5, true))).withBufferSize(n2)).setConfiguration(configuration)).withFileName(string)).withFilePattern(string2)).withFilter(filter)).withIgnoreExceptions(Booleans.parseBoolean(string8, true))).withImmediateFlush(Booleans.parseBoolean(string7, true))).withLayout(layout)).withCreateOnDemand(false)).withLocking(false)).withName(string4)).withPolicy(triggeringPolicy)).withStrategy(rolloverStrategy)).build();
    }

    @PluginBuilderFactory
    public static <B extends RollingFileAppender$Builder<B>> B newBuilder() {
        return (B)((RollingFileAppender$Builder)new RollingFileAppender$Builder().asBuilder());
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }
}

