/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Builder;

public class RollingFileAppender$Builder<B extends RollingFileAppender$Builder<B>>
extends AbstractOutputStreamAppender$Builder<B>
implements Builder<RollingFileAppender> {
    @PluginBuilderAttribute
    private String fileName;
    @PluginBuilderAttribute
    @Required
    private String filePattern;
    @PluginBuilderAttribute
    private boolean append = true;
    @PluginBuilderAttribute
    private boolean locking;
    @PluginElement(value="Policy")
    @Required
    private TriggeringPolicy policy;
    @PluginElement(value="Strategy")
    private RolloverStrategy strategy;
    @PluginBuilderAttribute
    private boolean advertise;
    @PluginBuilderAttribute
    private String advertiseUri;
    @PluginBuilderAttribute
    private boolean createOnDemand;

    @Override
    public RollingFileAppender build() {
        boolean bl2 = this.isBufferedIo();
        int n2 = this.getBufferSize();
        if (this.getName() == null) {
            RollingFileAppender.access$000().error("RollingFileAppender '{}': No name provided.", (Object)this.getName());
            return null;
        }
        if (!bl2 && n2 > 0) {
            RollingFileAppender.access$100().warn("RollingFileAppender '{}': The bufferSize is set to {} but bufferedIO is not true", (Object)this.getName(), (Object)n2);
        }
        if (this.filePattern == null) {
            RollingFileAppender.access$200().error("RollingFileAppender '{}': No file name pattern provided.", (Object)this.getName());
            return null;
        }
        if (this.policy == null) {
            RollingFileAppender.access$300().error("RollingFileAppender '{}': No TriggeringPolicy provided.", (Object)this.getName());
            return null;
        }
        if (this.strategy == null) {
            this.strategy = this.fileName != null ? DefaultRolloverStrategy.createStrategy(null, null, null, String.valueOf(-1), null, true, this.getConfiguration()) : DirectWriteRolloverStrategy.createStrategy(null, String.valueOf(-1), null, true, this.getConfiguration());
        } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
            RollingFileAppender.access$400().error("RollingFileAppender '{}': When no file name is provided a DirectFilenameRolloverStrategy must be configured");
            return null;
        }
        Layout<Serializable> layout = this.getOrCreateLayout();
        RollingFileManager rollingFileManager = RollingFileManager.getFileManager(this.fileName, this.filePattern, this.append, bl2, this.policy, this.strategy, this.advertiseUri, layout, n2, this.isImmediateFlush(), this.createOnDemand, this.getConfiguration());
        if (rollingFileManager == null) {
            return null;
        }
        rollingFileManager.initialize();
        return new RollingFileAppender(this.getName(), layout, this.getFilter(), rollingFileManager, this.fileName, this.filePattern, this.isIgnoreExceptions(), this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null, null);
    }

    public String getAdvertiseUri() {
        return this.advertiseUri;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isAdvertise() {
        return this.advertise;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isCreateOnDemand() {
        return this.createOnDemand;
    }

    public boolean isLocking() {
        return this.locking;
    }

    public B withAdvertise(boolean bl2) {
        this.advertise = bl2;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withAdvertiseUri(String string) {
        this.advertiseUri = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withAppend(boolean bl2) {
        this.append = bl2;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withFileName(String string) {
        this.fileName = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withCreateOnDemand(boolean bl2) {
        this.createOnDemand = bl2;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withLocking(boolean bl2) {
        this.locking = bl2;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public TriggeringPolicy getPolicy() {
        return this.policy;
    }

    public RolloverStrategy getStrategy() {
        return this.strategy;
    }

    public B withFilePattern(String string) {
        this.filePattern = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withPolicy(TriggeringPolicy triggeringPolicy) {
        this.policy = triggeringPolicy;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withStrategy(RolloverStrategy rolloverStrategy) {
        this.strategy = rolloverStrategy;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }
}

