/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender$1;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender$Builder;
import org.apache.logging.log4j.core.appender.RandomAccessFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable$Builder;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="RandomAccessFile", category="Core", elementType="appender", printObject=true)
public final class RandomAccessFileAppender
extends AbstractOutputStreamAppender<RandomAccessFileManager> {
    private final String fileName;
    private Object advertisement;
    private final Advertiser advertiser;

    private RandomAccessFileAppender(String string, Layout<? extends Serializable> layout, Filter filter, RandomAccessFileManager randomAccessFileManager, String string2, boolean bl2, boolean bl3, Advertiser advertiser) {
        super(string, layout, filter, bl2, bl3, randomAccessFileManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.putAll(randomAccessFileManager.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        }
        this.fileName = string2;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    @Override
    public void append(LogEvent logEvent) {
        ((RandomAccessFileManager)this.getManager()).setEndOfBatch(logEvent.isEndOfBatch());
        super.append(logEvent);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getBufferSize() {
        return ((RandomAccessFileManager)this.getManager()).getBufferSize();
    }

    @Deprecated
    public static <B extends RandomAccessFileAppender$Builder<B>> RandomAccessFileAppender createAppender(String string, String string2, String string3, String string4, String string5, String string6, Layout<? extends Serializable> layout, Filter filter, String string7, String string8, Configuration configuration) {
        boolean bl2 = Booleans.parseBoolean(string2, true);
        boolean bl3 = Booleans.parseBoolean(string4, true);
        boolean bl4 = Booleans.parseBoolean(string6, true);
        boolean bl5 = Boolean.parseBoolean(string7);
        int n2 = Integers.parseInt(string5, 262144);
        return ((RandomAccessFileAppender$Builder)((RandomAccessFileAppender$Builder)((RandomAccessFileAppender$Builder)((RandomAccessFileAppender$Builder)((RandomAccessFileAppender$Builder)((AbstractFilterable$Builder)((RandomAccessFileAppender$Builder)((RandomAccessFileAppender$Builder)((AbstractOutputStreamAppender$Builder)((RandomAccessFileAppender$Builder)((RandomAccessFileAppender$Builder)((RandomAccessFileAppender$Builder)RandomAccessFileAppender.newBuilder()).setAdvertise(bl5)).setAdvertiseURI(string8)).setAppend(bl2)).withBufferSize(n2)).setConfiguration(configuration)).setFileName(string)).withFilter(filter)).withIgnoreExceptions(bl4)).withImmediateFlush(bl3)).withLayout(layout)).withName(string3)).build();
    }

    @PluginBuilderFactory
    public static <B extends RandomAccessFileAppender$Builder<B>> B newBuilder() {
        return (B)((RandomAccessFileAppender$Builder)new RandomAccessFileAppender$Builder().asBuilder());
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    /* synthetic */ RandomAccessFileAppender(String string, Layout layout, Filter filter, RandomAccessFileManager randomAccessFileManager, String string2, boolean bl2, boolean bl3, Advertiser advertiser, RandomAccessFileAppender$1 randomAccessFileAppender$1) {
        this(string, layout, filter, randomAccessFileManager, string2, bl2, bl3, advertiser);
    }
}

