/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.util.Constants;

public class OutputStreamManager
extends AbstractManager
implements ByteBufferDestination {
    protected final Layout<?> layout;
    protected ByteBuffer byteBuffer;
    private volatile OutputStream os;
    private boolean skipFooter;

    protected OutputStreamManager(OutputStream outputStream, String string, Layout<?> layout, boolean bl2) {
        this(outputStream, string, layout, bl2, Constants.ENCODER_BYTE_BUFFER_SIZE);
    }

    protected OutputStreamManager(OutputStream outputStream, String string, Layout<?> layout, boolean bl2, int n2) {
        this(outputStream, string, layout, bl2, ByteBuffer.wrap(new byte[n2]));
    }

    @Deprecated
    protected OutputStreamManager(OutputStream outputStream, String string, Layout<?> layout, boolean bl2, ByteBuffer byteBuffer) {
        super(null, string);
        byte[] byArray;
        this.os = outputStream;
        this.layout = layout;
        if (bl2 && layout != null && (byArray = layout.getHeader()) != null) {
            try {
                this.getOutputStream().write(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                this.logError("Unable to write header", iOException);
            }
        }
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer");
    }

    protected OutputStreamManager(LoggerContext loggerContext, OutputStream outputStream, String string, boolean bl2, Layout<? extends Serializable> layout, boolean bl3, ByteBuffer byteBuffer) {
        super(loggerContext, string);
        byte[] byArray;
        if (bl2 && outputStream != null) {
            LOGGER.error("Invalid OutputStreamManager configuration for '{}': You cannot both set the OutputStream and request on-demand.", (Object)string);
        }
        this.layout = layout;
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer");
        this.os = outputStream;
        if (bl3 && layout != null && (byArray = layout.getHeader()) != null) {
            try {
                this.getOutputStream().write(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                this.logError("Unable to write header for " + string, iOException);
            }
        }
    }

    public static <T> OutputStreamManager getManager(String string, T t2, ManagerFactory<? extends OutputStreamManager, T> managerFactory) {
        return AbstractManager.getManager(string, managerFactory, t2);
    }

    protected OutputStream createOutputStream() {
        throw new IllegalStateException(this.getClass().getCanonicalName() + " must implement createOutputStream()");
    }

    public void skipFooter(boolean bl2) {
        this.skipFooter = bl2;
    }

    @Override
    public boolean releaseSub(long l2, TimeUnit timeUnit) {
        this.writeFooter();
        return this.closeOutputStream();
    }

    protected void writeFooter() {
        if (this.layout == null || this.skipFooter) {
            return;
        }
        byte[] byArray = this.layout.getFooter();
        if (byArray != null) {
            this.write(byArray);
        }
    }

    public boolean isOpen() {
        return this.getCount() > 0;
    }

    public boolean hasOutputStream() {
        return this.os != null;
    }

    protected OutputStream getOutputStream() {
        if (this.os == null) {
            this.os = this.createOutputStream();
        }
        return this.os;
    }

    protected void setOutputStream(OutputStream outputStream) {
        byte[] byArray = this.layout.getHeader();
        if (byArray != null) {
            try {
                outputStream.write(byArray, 0, byArray.length);
                this.os = outputStream;
            }
            catch (IOException iOException) {
                this.logError("Unable to write header", iOException);
            }
        } else {
            this.os = outputStream;
        }
    }

    protected void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length, false);
    }

    protected void write(byte[] byArray, boolean bl2) {
        this.write(byArray, 0, byArray.length, bl2);
    }

    protected void write(byte[] byArray, int n2, int n3) {
        this.write(byArray, n2, n3, false);
    }

    protected synchronized void write(byte[] byArray, int n2, int n3, boolean bl2) {
        if (bl2 && this.byteBuffer.position() == 0) {
            this.writeToDestination(byArray, n2, n3);
            this.flushDestination();
            return;
        }
        if (n3 >= this.byteBuffer.capacity()) {
            this.flush();
            this.writeToDestination(byArray, n2, n3);
        } else {
            if (n3 > this.byteBuffer.remaining()) {
                this.flush();
            }
            this.byteBuffer.put(byArray, n2, n3);
        }
        if (bl2) {
            this.flush();
        }
    }

    protected synchronized void writeToDestination(byte[] byArray, int n2, int n3) {
        try {
            this.getOutputStream().write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AppenderLoggingException("Error writing to stream " + this.getName(), iOException);
        }
    }

    protected synchronized void flushDestination() {
        OutputStream outputStream = this.os;
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                throw new AppenderLoggingException("Error flushing stream " + this.getName(), iOException);
            }
        }
    }

    protected synchronized void flushBuffer(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        if (byteBuffer.limit() > 0) {
            this.writeToDestination(byteBuffer.array(), 0, byteBuffer.limit());
        }
        byteBuffer.clear();
    }

    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
        this.flushDestination();
    }

    protected synchronized boolean closeOutputStream() {
        this.flush();
        OutputStream outputStream = this.os;
        if (outputStream == null || outputStream == System.out || outputStream == System.err) {
            return true;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            this.logError("Unable to close stream", iOException);
            return false;
        }
        return true;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public ByteBuffer drain(ByteBuffer byteBuffer) {
        this.flushBuffer(byteBuffer);
        return byteBuffer;
    }
}

