/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.OutputStreamAppender$FactoryData;
import org.apache.logging.log4j.core.appender.OutputStreamAppender$OutputStreamManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.CloseShieldOutputStream;

@Plugin(name="OutputStream", category="Core", elementType="appender", printObject=true)
public final class OutputStreamAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    private static OutputStreamAppender$OutputStreamManagerFactory factory = new OutputStreamAppender$OutputStreamManagerFactory();

    @PluginFactory
    public static OutputStreamAppender createAppender(Layout<? extends Serializable> patternLayout, Filter filter, OutputStream outputStream, String string, boolean bl2, boolean bl3) {
        if (string == null) {
            LOGGER.error("No name provided for OutputStreamAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        return new OutputStreamAppender(string, patternLayout, filter, OutputStreamAppender.getManager(outputStream, bl2, patternLayout), bl3);
    }

    private static OutputStreamManager getManager(OutputStream outputStream, boolean bl2, Layout<? extends Serializable> layout) {
        CloseShieldOutputStream closeShieldOutputStream = new CloseShieldOutputStream(outputStream);
        String string = outputStream.getClass().getName() + "@" + Integer.toHexString(outputStream.hashCode()) + '.' + bl2;
        return OutputStreamManager.getManager(string, new OutputStreamAppender$FactoryData(closeShieldOutputStream, string, layout), factory);
    }

    @PluginBuilderFactory
    public static OutputStreamAppender$Builder newBuilder() {
        return new OutputStreamAppender$Builder();
    }

    private OutputStreamAppender(String string, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager outputStreamManager, boolean bl2) {
        super(string, layout, filter, bl2, true, outputStreamManager);
    }

    static /* synthetic */ OutputStreamManager access$000(OutputStream outputStream, boolean bl2, Layout layout) {
        return OutputStreamAppender.getManager(outputStream, bl2, layout);
    }
}

