/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.MemoryMappedFileManager$1;
import org.apache.logging.log4j.core.appender.MemoryMappedFileManager$FactoryData;
import org.apache.logging.log4j.core.appender.MemoryMappedFileManager$MemoryMappedFileManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;

public class MemoryMappedFileManager
extends OutputStreamManager {
    static final int DEFAULT_REGION_LENGTH = 0x2000000;
    private static final int MAX_REMAP_COUNT = 10;
    private static final MemoryMappedFileManager$MemoryMappedFileManagerFactory FACTORY = new MemoryMappedFileManager$MemoryMappedFileManagerFactory(null);
    private static final double NANOS_PER_MILLISEC = 1000000.0;
    private final boolean immediateFlush;
    private final int regionLength;
    private final String advertiseURI;
    private final RandomAccessFile randomAccessFile;
    private final ThreadLocal<Boolean> isEndOfBatch = new ThreadLocal();
    private MappedByteBuffer mappedBuffer;
    private long mappingOffset;

    protected MemoryMappedFileManager(RandomAccessFile randomAccessFile, String string, OutputStream outputStream, boolean bl2, long l2, int n2, String string2, Layout<? extends Serializable> layout, boolean bl3) {
        super(outputStream, string, layout, bl3, ByteBuffer.wrap(new byte[0]));
        this.immediateFlush = bl2;
        this.randomAccessFile = Objects.requireNonNull(randomAccessFile, "RandomAccessFile");
        this.regionLength = n2;
        this.advertiseURI = string2;
        this.isEndOfBatch.set(Boolean.FALSE);
        this.mappedBuffer = MemoryMappedFileManager.mmap(this.randomAccessFile.getChannel(), this.getFileName(), l2, n2);
        this.byteBuffer = this.mappedBuffer;
        this.mappingOffset = l2;
    }

    public static MemoryMappedFileManager getFileManager(String string, boolean bl2, boolean bl3, int n2, String string2, Layout<? extends Serializable> layout) {
        return (MemoryMappedFileManager)MemoryMappedFileManager.getManager(string, new MemoryMappedFileManager$FactoryData(bl2, bl3, n2, string2, layout), FACTORY);
    }

    public Boolean isEndOfBatch() {
        return this.isEndOfBatch.get();
    }

    public void setEndOfBatch(boolean bl2) {
        this.isEndOfBatch.set(bl2);
    }

    @Override
    protected synchronized void write(byte[] byArray, int n2, int n3, boolean bl2) {
        while (n3 > this.mappedBuffer.remaining()) {
            int n4 = this.mappedBuffer.remaining();
            this.mappedBuffer.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
            this.remap();
        }
        this.mappedBuffer.put(byArray, n2, n3);
    }

    private synchronized void remap() {
        long l2 = this.mappingOffset + (long)this.mappedBuffer.position();
        int n2 = this.mappedBuffer.remaining() + this.regionLength;
        try {
            MemoryMappedFileManager.unsafeUnmap(this.mappedBuffer);
            long l3 = this.randomAccessFile.length() + (long)this.regionLength;
            LOGGER.debug("{} {} extending {} by {} bytes to {}", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)this.getFileName(), (Object)this.regionLength, (Object)l3);
            long l4 = System.nanoTime();
            this.randomAccessFile.setLength(l3);
            float f2 = (float)((double)(System.nanoTime() - l4) / 1000000.0);
            LOGGER.debug("{} {} extended {} OK in {} millis", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)this.getFileName(), (Object)Float.valueOf(f2));
            this.mappedBuffer = MemoryMappedFileManager.mmap(this.randomAccessFile.getChannel(), this.getFileName(), l2, n2);
            this.byteBuffer = this.mappedBuffer;
            this.mappingOffset = l2;
        }
        catch (Exception exception) {
            this.logError("Unable to remap", exception);
        }
    }

    @Override
    public synchronized void flush() {
        this.mappedBuffer.force();
    }

    @Override
    public synchronized boolean closeOutputStream() {
        long l2 = this.mappedBuffer.position();
        long l3 = this.mappingOffset + l2;
        try {
            MemoryMappedFileManager.unsafeUnmap(this.mappedBuffer);
        }
        catch (Exception exception) {
            this.logError("Unable to unmap MappedBuffer", exception);
        }
        try {
            LOGGER.debug("MMapAppender closing. Setting {} length to {} (offset {} + position {})", (Object)this.getFileName(), (Object)l3, (Object)this.mappingOffset, (Object)l2);
            this.randomAccessFile.setLength(l3);
            this.randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            this.logError("Unable to close MemoryMappedFile", iOException);
            return false;
        }
    }

    public static MappedByteBuffer mmap(FileChannel fileChannel, String string, long l2, int n2) {
        int n3 = 1;
        while (true) {
            try {
                LOGGER.debug("MMapAppender remapping {} start={}, size={}", (Object)string, (Object)l2, (Object)n2);
                long l3 = System.nanoTime();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l2, n2);
                mappedByteBuffer.order(ByteOrder.nativeOrder());
                float f2 = (float)((double)(System.nanoTime() - l3) / 1000000.0);
                LOGGER.debug("MMapAppender remapped {} OK in {} millis", (Object)string, (Object)Float.valueOf(f2));
                return mappedByteBuffer;
            }
            catch (IOException iOException) {
                if (iOException.getMessage() == null || !iOException.getMessage().endsWith("user-mapped section open")) {
                    throw iOException;
                }
                LOGGER.debug("Remap attempt {}/{} failed. Retrying...", (Object)n3, (Object)10, (Object)iOException);
                if (n3 < 10) {
                    Thread.yield();
                } else {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw iOException;
                    }
                }
                ++n3;
                continue;
            }
            break;
        }
    }

    private static void unsafeUnmap(MappedByteBuffer mappedByteBuffer) {
        LOGGER.debug("MMapAppender unmapping old buffer...");
        long l2 = System.nanoTime();
        AccessController.doPrivileged(new MemoryMappedFileManager$1(mappedByteBuffer));
        float f2 = (float)((double)(System.nanoTime() - l2) / 1000000.0);
        LOGGER.debug("MMapAppender unmapped buffer OK in {} millis", (Object)Float.valueOf(f2));
    }

    public String getFileName() {
        return this.getName();
    }

    public int getRegionLength() {
        return this.regionLength;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("fileURI", this.advertiseURI);
        return hashMap;
    }

    @Override
    protected void flushBuffer(ByteBuffer byteBuffer) {
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.mappedBuffer;
    }

    @Override
    public ByteBuffer drain(ByteBuffer byteBuffer) {
        this.remap();
        return this.mappedBuffer;
    }
}

