/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.FileManager$FactoryData;
import org.apache.logging.log4j.core.appender.FileManager$FileManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;

public class FileManager
extends OutputStreamManager {
    private static final FileManager$FileManagerFactory FACTORY = new FileManager$FileManagerFactory();
    private final boolean isAppend;
    private final boolean createOnDemand;
    private final boolean isLocking;
    private final String advertiseURI;
    private final int bufferSize;

    @Deprecated
    protected FileManager(String string, OutputStream outputStream, boolean bl2, boolean bl3, String string2, Layout<? extends Serializable> layout, int n2, boolean bl4) {
        this(string, outputStream, bl2, bl3, string2, layout, bl4, ByteBuffer.wrap(new byte[n2]));
    }

    @Deprecated
    protected FileManager(String string, OutputStream outputStream, boolean bl2, boolean bl3, String string2, Layout<? extends Serializable> layout, boolean bl4, ByteBuffer byteBuffer) {
        super(outputStream, string, layout, bl4, byteBuffer);
        this.isAppend = bl2;
        this.createOnDemand = false;
        this.isLocking = bl3;
        this.advertiseURI = string2;
        this.bufferSize = byteBuffer.capacity();
    }

    protected FileManager(LoggerContext loggerContext, String string, OutputStream outputStream, boolean bl2, boolean bl3, boolean bl4, String string2, Layout<? extends Serializable> layout, boolean bl5, ByteBuffer byteBuffer) {
        super(loggerContext, outputStream, string, bl4, layout, bl5, byteBuffer);
        this.isAppend = bl2;
        this.createOnDemand = bl4;
        this.isLocking = bl3;
        this.advertiseURI = string2;
        this.bufferSize = byteBuffer.capacity();
    }

    public static FileManager getFileManager(String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string2, Layout<? extends Serializable> layout, int n2, Configuration configuration) {
        if (bl3 && bl4) {
            bl3 = false;
        }
        return (FileManager)FileManager.getManager(string, new FileManager$FactoryData(bl2, bl3, bl4, n2, bl5, string2, layout, configuration), FACTORY);
    }

    @Override
    protected OutputStream createOutputStream() {
        String string = this.getFileName();
        LOGGER.debug("Now writing to {} at {}", (Object)string, (Object)new Date());
        return new FileOutputStream(string, this.isAppend);
    }

    @Override
    protected synchronized void write(byte[] byArray, int n2, int n3, boolean bl2) {
        block15: {
            if (this.isLocking) {
                try {
                    FileChannel fileChannel = ((FileOutputStream)this.getOutputStream()).getChannel();
                    try (FileLock fileLock = fileChannel.lock(0L, Long.MAX_VALUE, false);){
                        super.write(byArray, n2, n3, bl2);
                        break block15;
                    }
                }
                catch (IOException iOException) {
                    throw new AppenderLoggingException("Unable to obtain lock on " + this.getName(), iOException);
                }
            }
            super.write(byArray, n2, n3, bl2);
        }
    }

    @Override
    protected synchronized void writeToDestination(byte[] byArray, int n2, int n3) {
        block15: {
            if (this.isLocking) {
                try {
                    FileChannel fileChannel = ((FileOutputStream)this.getOutputStream()).getChannel();
                    try (FileLock fileLock = fileChannel.lock(0L, Long.MAX_VALUE, false);){
                        super.writeToDestination(byArray, n2, n3);
                        break block15;
                    }
                }
                catch (IOException iOException) {
                    throw new AppenderLoggingException("Unable to obtain lock on " + this.getName(), iOException);
                }
            }
            super.writeToDestination(byArray, n2, n3);
        }
    }

    public String getFileName() {
        return this.getName();
    }

    public boolean isAppend() {
        return this.isAppend;
    }

    public boolean isCreateOnDemand() {
        return this.createOnDemand;
    }

    public boolean isLocking() {
        return this.isLocking;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("fileURI", this.advertiseURI);
        return hashMap;
    }
}

