/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Builder;

public class FileAppender$Builder<B extends FileAppender$Builder<B>>
extends AbstractOutputStreamAppender$Builder<B>
implements Builder<FileAppender> {
    @PluginBuilderAttribute
    @Required
    private String fileName;
    @PluginBuilderAttribute
    private boolean append = true;
    @PluginBuilderAttribute
    private boolean locking;
    @PluginBuilderAttribute
    private boolean advertise;
    @PluginBuilderAttribute
    private String advertiseUri;
    @PluginBuilderAttribute
    private boolean createOnDemand;

    @Override
    public FileAppender build() {
        Layout<Serializable> layout;
        FileManager fileManager;
        boolean bl2 = this.isBufferedIo();
        int n2 = this.getBufferSize();
        if (this.locking && bl2) {
            FileAppender.access$000().warn("Locking and buffering are mutually exclusive. No buffering will occur for {}", (Object)this.fileName);
            bl2 = false;
        }
        if (!bl2 && n2 > 0) {
            FileAppender.access$100().warn("The bufferSize is set to {} but bufferedIo is false: {}", (Object)n2, (Object)bl2);
        }
        if ((fileManager = FileManager.getFileManager(this.fileName, this.append, this.locking, bl2, this.createOnDemand, this.advertiseUri, layout = this.getOrCreateLayout(), n2, this.getConfiguration())) == null) {
            return null;
        }
        return new FileAppender(this.getName(), layout, this.getFilter(), fileManager, this.fileName, this.isIgnoreExceptions(), !bl2 || this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null);
    }

    public String getAdvertiseUri() {
        return this.advertiseUri;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isAdvertise() {
        return this.advertise;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isCreateOnDemand() {
        return this.createOnDemand;
    }

    public boolean isLocking() {
        return this.locking;
    }

    public B withAdvertise(boolean bl2) {
        this.advertise = bl2;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withAdvertiseUri(String string) {
        this.advertiseUri = string;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withAppend(boolean bl2) {
        this.append = bl2;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withFileName(String string) {
        this.fileName = string;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withCreateOnDemand(boolean bl2) {
        this.createOnDemand = bl2;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withLocking(boolean bl2) {
        this.locking = bl2;
        return (B)((FileAppender$Builder)this.asBuilder());
    }
}

