/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender$Builder;
import org.apache.logging.log4j.core.appender.ConsoleAppender$ConsoleManagerFactory;
import org.apache.logging.log4j.core.appender.ConsoleAppender$FactoryData;
import org.apache.logging.log4j.core.appender.ConsoleAppender$SystemErrStream;
import org.apache.logging.log4j.core.appender.ConsoleAppender$SystemOutStream;
import org.apache.logging.log4j.core.appender.ConsoleAppender$Target;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.CloseShieldOutputStream;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="Console", category="Core", elementType="appender", printObject=true)
public final class ConsoleAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    public static final String PLUGIN_NAME = "Console";
    private static final String JANSI_CLASS = "org.fusesource.jansi.WindowsAnsiOutputStream";
    private static ConsoleAppender$ConsoleManagerFactory factory = new ConsoleAppender$ConsoleManagerFactory(null);
    private static final ConsoleAppender$Target DEFAULT_TARGET = ConsoleAppender$Target.SYSTEM_OUT;
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final ConsoleAppender$Target target;

    private ConsoleAppender(String string, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager outputStreamManager, boolean bl2, ConsoleAppender$Target consoleAppender$Target) {
        super(string, layout, filter, bl2, true, outputStreamManager);
        this.target = consoleAppender$Target;
    }

    @Deprecated
    public static ConsoleAppender createAppender(Layout<? extends Serializable> patternLayout, Filter filter, String string, String string2, String string3, String string4) {
        if (string2 == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        boolean bl2 = Boolean.parseBoolean(string3);
        boolean bl3 = Booleans.parseBoolean(string4, true);
        ConsoleAppender$Target consoleAppender$Target = string == null ? DEFAULT_TARGET : ConsoleAppender$Target.valueOf(string);
        return new ConsoleAppender(string2, (Layout<? extends Serializable>)patternLayout, filter, ConsoleAppender.getManager(consoleAppender$Target, bl2, false, patternLayout), bl3, consoleAppender$Target);
    }

    @Deprecated
    public static ConsoleAppender createAppender(Layout<? extends Serializable> patternLayout, Filter filter, ConsoleAppender$Target consoleAppender$Target, String string, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        ConsoleAppender$Target consoleAppender$Target2 = consoleAppender$Target = consoleAppender$Target == null ? ConsoleAppender$Target.SYSTEM_OUT : consoleAppender$Target;
        if (bl2 && bl3) {
            LOGGER.error("Cannot use both follow and direct on ConsoleAppender");
            return null;
        }
        return new ConsoleAppender(string, (Layout<? extends Serializable>)patternLayout, filter, ConsoleAppender.getManager(consoleAppender$Target, bl2, bl3, patternLayout), bl4, consoleAppender$Target);
    }

    public static ConsoleAppender createDefaultAppenderForLayout(Layout<? extends Serializable> layout) {
        return new ConsoleAppender("DefaultConsole-" + COUNT.incrementAndGet(), layout, null, ConsoleAppender.getDefaultManager(DEFAULT_TARGET, false, false, layout), true, DEFAULT_TARGET);
    }

    @PluginBuilderFactory
    public static <B extends ConsoleAppender$Builder<B>> B newBuilder() {
        return (B)((ConsoleAppender$Builder)new ConsoleAppender$Builder().asBuilder());
    }

    private static OutputStreamManager getDefaultManager(ConsoleAppender$Target consoleAppender$Target, boolean bl2, boolean bl3, Layout<? extends Serializable> layout) {
        OutputStream outputStream = ConsoleAppender.getOutputStream(bl2, bl3, consoleAppender$Target);
        String string = consoleAppender$Target.name() + '.' + bl2 + '.' + bl3 + "-" + COUNT.get();
        return OutputStreamManager.getManager(string, new ConsoleAppender$FactoryData(outputStream, string, layout), factory);
    }

    private static OutputStreamManager getManager(ConsoleAppender$Target consoleAppender$Target, boolean bl2, boolean bl3, Layout<? extends Serializable> layout) {
        OutputStream outputStream = ConsoleAppender.getOutputStream(bl2, bl3, consoleAppender$Target);
        String string = consoleAppender$Target.name() + '.' + bl2 + '.' + bl3;
        return OutputStreamManager.getManager(string, new ConsoleAppender$FactoryData(outputStream, string, layout), factory);
    }

    private static OutputStream getOutputStream(boolean bl2, boolean bl3, ConsoleAppender$Target consoleAppender$Target) {
        OutputStream outputStream;
        String string = Charset.defaultCharset().name();
        try {
            outputStream = consoleAppender$Target == ConsoleAppender$Target.SYSTEM_OUT ? (bl3 ? new FileOutputStream(FileDescriptor.out) : (bl2 ? new PrintStream((OutputStream)new ConsoleAppender$SystemOutStream(), true, string) : System.out)) : (bl3 ? new FileOutputStream(FileDescriptor.err) : (bl2 ? new PrintStream((OutputStream)new ConsoleAppender$SystemErrStream(), true, string) : System.err));
            outputStream = new CloseShieldOutputStream(outputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Unsupported default encoding " + string, unsupportedEncodingException);
        }
        PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
        if (!propertiesUtil.isOsWindows() || propertiesUtil.getBooleanProperty("log4j.skipJansi") || bl3) {
            return outputStream;
        }
        try {
            Class<?> clazz = LoaderUtil.loadClass(JANSI_CLASS);
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class);
            return new CloseShieldOutputStream((OutputStream)constructor.newInstance(outputStream));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.debug("Jansi is not installed, cannot find {}", (Object)JANSI_CLASS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.warn("{} is missing the proper constructor", (Object)JANSI_CLASS);
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to instantiate {}", (Object)JANSI_CLASS);
        }
        return outputStream;
    }

    public ConsoleAppender$Target getTarget() {
        return this.target;
    }

    static /* synthetic */ ConsoleAppender$Target access$200() {
        return DEFAULT_TARGET;
    }

    static /* synthetic */ OutputStreamManager access$300(ConsoleAppender$Target consoleAppender$Target, boolean bl2, boolean bl3, Layout layout) {
        return ConsoleAppender.getManager(consoleAppender$Target, bl2, bl3, layout);
    }
}

