/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AsyncAppender$1;
import org.apache.logging.log4j.core.appender.AsyncAppender$AsyncThread;
import org.apache.logging.log4j.core.appender.AsyncAppender$Builder;
import org.apache.logging.log4j.core.async.ArrayBlockingQueueFactory;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.BlockingQueueFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.Message;

@Plugin(name="Async", category="Core", elementType="appender", printObject=true)
public final class AsyncAppender
extends AbstractAppender {
    private static final int DEFAULT_QUEUE_SIZE = 128;
    private static final LogEvent SHUTDOWN_LOG_EVENT = new AsyncAppender$1();
    private static final AtomicLong THREAD_SEQUENCE = new AtomicLong(1L);
    private final BlockingQueue<LogEvent> queue;
    private final int queueSize;
    private final boolean blocking;
    private final long shutdownTimeout;
    private final Configuration config;
    private final AppenderRef[] appenderRefs;
    private final String errorRef;
    private final boolean includeLocation;
    private AppenderControl errorAppender;
    private AsyncAppender$AsyncThread thread;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;

    private AsyncAppender(String string, Filter filter, AppenderRef[] appenderRefArray, String string2, int n2, boolean bl2, boolean bl3, long l2, Configuration configuration, boolean bl4, BlockingQueueFactory<LogEvent> blockingQueueFactory) {
        super(string, filter, null, bl3);
        this.queue = blockingQueueFactory.create(n2);
        this.queueSize = n2;
        this.blocking = bl2;
        this.shutdownTimeout = l2;
        this.config = configuration;
        this.appenderRefs = appenderRefArray;
        this.errorRef = string2;
        this.includeLocation = bl4;
    }

    @Override
    public void start() {
        Map<String, Appender> map = this.config.getAppenders();
        ArrayList<AppenderControl> arrayList = new ArrayList<AppenderControl>();
        for (AppenderRef appenderRef : this.appenderRefs) {
            Appender appender = map.get(appenderRef.getRef());
            if (appender != null) {
                arrayList.add(new AppenderControl(appender, appenderRef.getLevel(), appenderRef.getFilter()));
                continue;
            }
            LOGGER.error("No appender named {} was configured", (Object)appenderRef);
        }
        if (this.errorRef != null) {
            Appender appender = map.get(this.errorRef);
            if (appender != null) {
                this.errorAppender = new AppenderControl(appender, null, null);
            } else {
                LOGGER.error("Unable to set up error Appender. No appender named {} was configured", (Object)this.errorRef);
            }
        }
        if (arrayList.size() > 0) {
            this.thread = new AsyncAppender$AsyncThread(this, arrayList, this.queue);
            this.thread.setName("AsyncAppender-" + this.getName());
        } else if (this.errorRef == null) {
            throw new ConfigurationException("No appenders are available for AsyncAppender " + this.getName());
        }
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.thread.start();
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        LOGGER.trace("AsyncAppender stopping. Queue still has {} events.", (Object)this.queue.size());
        this.thread.shutdown();
        try {
            this.thread.join(this.shutdownTimeout);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("Interrupted while stopping AsyncAppender {}", (Object)this.getName());
        }
        LOGGER.trace("AsyncAppender stopped. Queue has {} events.", (Object)this.queue.size());
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncAppender: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    @Override
    public void append(LogEvent logEvent) {
        Log4jLogEvent log4jLogEvent;
        if (!this.isStarted()) {
            throw new IllegalStateException("AsyncAppender " + this.getName() + " is not active");
        }
        if (!this.canFormatMessageInBackground(logEvent.getMessage())) {
            logEvent.getMessage().getFormattedMessage();
        }
        if (!this.transfer(log4jLogEvent = Log4jLogEvent.createMemento(logEvent, this.includeLocation))) {
            if (this.blocking) {
                EventRoute eventRoute = this.asyncQueueFullPolicy.getRoute(this.thread.getId(), log4jLogEvent.getLevel());
                eventRoute.logMessage(this, (LogEvent)log4jLogEvent);
            } else {
                this.error("Appender " + this.getName() + " is unable to write primary appenders. queue is full");
                this.logToErrorAppenderIfNecessary(false, log4jLogEvent);
            }
        }
    }

    private boolean canFormatMessageInBackground(Message message) {
        return Constants.FORMAT_MESSAGES_IN_BACKGROUND || message.getClass().isAnnotationPresent(AsynchronouslyFormattable.class);
    }

    private boolean transfer(LogEvent logEvent) {
        return this.queue instanceof TransferQueue ? ((TransferQueue)this.queue).tryTransfer(logEvent) : this.queue.offer(logEvent);
    }

    public void logMessageInCurrentThread(LogEvent logEvent) {
        logEvent.setEndOfBatch(this.queue.isEmpty());
        boolean bl2 = this.thread.callAppenders(logEvent);
        this.logToErrorAppenderIfNecessary(bl2, logEvent);
    }

    public void logMessageInBackgroundThread(LogEvent logEvent) {
        try {
            this.queue.put(logEvent);
        }
        catch (InterruptedException interruptedException) {
            boolean bl2 = this.handleInterruptedException(logEvent);
            this.logToErrorAppenderIfNecessary(bl2, logEvent);
        }
    }

    private boolean handleInterruptedException(LogEvent logEvent) {
        boolean bl2 = this.queue.offer(logEvent);
        if (!bl2) {
            LOGGER.warn("Interrupted while waiting for a free slot in the AsyncAppender LogEvent-queue {}", (Object)this.getName());
        }
        Thread.currentThread().interrupt();
        return bl2;
    }

    private void logToErrorAppenderIfNecessary(boolean bl2, LogEvent logEvent) {
        if (!bl2 && this.errorAppender != null) {
            this.errorAppender.callAppender(logEvent);
        }
    }

    @Deprecated
    public static AsyncAppender createAppender(AppenderRef[] appenderRefArray, String string, boolean bl2, long l2, int n2, String string2, boolean bl3, Filter filter, Configuration configuration, boolean bl4) {
        if (string2 == null) {
            LOGGER.error("No name provided for AsyncAppender");
            return null;
        }
        if (appenderRefArray == null) {
            LOGGER.error("No appender references provided to AsyncAppender {}", (Object)string2);
        }
        return new AsyncAppender(string2, filter, appenderRefArray, string, n2, bl2, bl4, l2, configuration, bl3, new ArrayBlockingQueueFactory<LogEvent>());
    }

    @PluginBuilderFactory
    public static AsyncAppender$Builder newBuilder() {
        return new AsyncAppender$Builder();
    }

    public String[] getAppenderRefStrings() {
        String[] stringArray = new String[this.appenderRefs.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.appenderRefs[i2].getRef();
        }
        return stringArray;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public String getErrorRef() {
        return this.errorRef;
    }

    public int getQueueCapacity() {
        return this.queueSize;
    }

    public int getQueueRemainingCapacity() {
        return this.queue.remainingCapacity();
    }

    /* synthetic */ AsyncAppender(String string, Filter filter, AppenderRef[] appenderRefArray, String string2, int n2, boolean bl2, boolean bl3, long l2, Configuration configuration, boolean bl4, BlockingQueueFactory blockingQueueFactory, AsyncAppender$1 asyncAppender$1) {
        this(string, filter, appenderRefArray, string2, n2, bl2, bl3, l2, configuration, bl4, blockingQueueFactory);
    }

    static /* synthetic */ AtomicLong access$100() {
        return THREAD_SEQUENCE;
    }

    static /* synthetic */ LogEvent access$200() {
        return SHUTDOWN_LOG_EVENT;
    }

    static /* synthetic */ AppenderControl access$300(AsyncAppender asyncAppender) {
        return asyncAppender.errorAppender;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }
}

