/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Log4jThread;

class AsyncAppender$AsyncThread
extends Log4jThread {
    private volatile boolean shutdown;
    private final List<AppenderControl> appenders;
    private final BlockingQueue<LogEvent> queue;
    final /* synthetic */ AsyncAppender this$0;

    public AsyncAppender$AsyncThread(AsyncAppender asyncAppender, List<AppenderControl> list, BlockingQueue<LogEvent> blockingQueue) {
        this.this$0 = asyncAppender;
        super("AsyncAppender-" + AsyncAppender.access$100().getAndIncrement());
        this.shutdown = false;
        this.appenders = list;
        this.queue = blockingQueue;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            LogEvent logEvent;
            try {
                logEvent = this.queue.take();
                if (logEvent == AsyncAppender.access$200()) {
                    this.shutdown = true;
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            logEvent.setEndOfBatch(this.queue.isEmpty());
            boolean bl2 = this.callAppenders(logEvent);
            if (bl2 || AsyncAppender.access$300(this.this$0) == null) continue;
            try {
                AsyncAppender.access$300(this.this$0).callAppender(logEvent);
            }
            catch (Exception exception) {}
        }
        AsyncAppender.access$400().trace("AsyncAppender.AsyncThread shutting down. Processing remaining {} queue events.", (Object)this.queue.size());
        int n2 = 0;
        int n3 = 0;
        while (!this.queue.isEmpty()) {
            try {
                LogEvent logEvent = this.queue.take();
                if (logEvent instanceof Log4jLogEvent) {
                    Log4jLogEvent log4jLogEvent = (Log4jLogEvent)logEvent;
                    log4jLogEvent.setEndOfBatch(this.queue.isEmpty());
                    this.callAppenders(log4jLogEvent);
                    ++n2;
                    continue;
                }
                ++n3;
                AsyncAppender.access$500().trace("Ignoring event of class {}", (Object)logEvent.getClass().getName());
            }
            catch (InterruptedException interruptedException) {}
        }
        AsyncAppender.access$600().trace("AsyncAppender.AsyncThread stopped. Queue has {} events remaining. Processed {} and ignored {} events since shutdown started.", (Object)this.queue.size(), (Object)n2, (Object)n3);
    }

    boolean callAppenders(LogEvent logEvent) {
        boolean bl2 = false;
        for (AppenderControl appenderControl : this.appenders) {
            try {
                appenderControl.callAppender(logEvent);
                bl2 = true;
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.queue.isEmpty()) {
            this.queue.offer(AsyncAppender.access$200());
        }
        if (this.getState() == Thread.State.TIMED_WAITING || this.getState() == Thread.State.WAITING) {
            this.interrupt();
        }
    }
}

