/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.Map;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.AppenderSet$Builder;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="AppenderSet", category="Core", printObject=true, deferChildren=true)
public class AppenderSet {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private final Configuration configuration;
    private final Map<String, Node> nodeMap;

    @PluginBuilderFactory
    public static AppenderSet$Builder newBuilder() {
        return new AppenderSet$Builder();
    }

    private AppenderSet(Configuration configuration, Map<String, Node> map) {
        this.configuration = configuration;
        this.nodeMap = map;
    }

    public Appender createAppender(String string, String string2) {
        Node node = this.nodeMap.get(string);
        if (node == null) {
            LOGGER.error("No node named {} in {}", (Object)string, (Object)this);
            return null;
        }
        node.getAttributes().put("name", string2);
        if (node.getType().getElementName().equals("appender")) {
            Node node2 = new Node(node);
            this.configuration.createConfiguration(node2, null);
            if (node2.getObject() instanceof Appender) {
                Appender appender = (Appender)node2.getObject();
                appender.start();
                return appender;
            }
            LOGGER.error("Unable to create Appender of type " + node.getName());
            return null;
        }
        LOGGER.error("No Appender was configured for name {} " + string);
        return null;
    }

    static /* synthetic */ StatusLogger access$000() {
        return LOGGER;
    }
}

