/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Arrays;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public class MarkerManager$Log4jMarker
implements Marker,
StringBuilderFormattable {
    private static final long serialVersionUID = 100L;
    private final String name;
    private volatile Marker[] parents;

    private MarkerManager$Log4jMarker() {
        this.name = null;
        this.parents = null;
    }

    public MarkerManager$Log4jMarker(String string) {
        MarkerManager.access$000(string, "Marker name cannot be null.");
        this.name = string;
        this.parents = null;
    }

    @Override
    public synchronized Marker addParents(Marker ... markerArray) {
        MarkerManager.access$000(markerArray, "A parent marker must be specified");
        Marker[] markerArray2 = this.parents;
        int n2 = 0;
        int n3 = markerArray.length;
        if (markerArray2 != null) {
            for (Marker marker : markerArray) {
                if (MarkerManager$Log4jMarker.contains(marker, markerArray2) || marker.isInstanceOf(this)) continue;
                ++n2;
            }
            if (n2 == 0) {
                return this;
            }
            n3 = markerArray2.length + n2;
        }
        Marker[] markerArray3 = new Marker[n3];
        if (markerArray2 != null) {
            System.arraycopy(markerArray2, 0, markerArray3, 0, markerArray2.length);
        }
        int n4 = markerArray2 == null ? 0 : markerArray2.length;
        for (Marker marker : markerArray) {
            if (markerArray2 != null && (MarkerManager$Log4jMarker.contains(marker, markerArray2) || marker.isInstanceOf(this))) continue;
            markerArray3[n4++] = marker;
        }
        this.parents = markerArray3;
        return this;
    }

    @Override
    public synchronized boolean remove(Marker marker) {
        MarkerManager.access$000(marker, "A parent marker must be specified");
        Marker[] markerArray = this.parents;
        if (markerArray == null) {
            return false;
        }
        int n2 = markerArray.length;
        if (n2 == 1) {
            if (markerArray[0].equals(marker)) {
                this.parents = null;
                return true;
            }
            return false;
        }
        int n3 = 0;
        Marker[] markerArray2 = new Marker[n2 - 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            Marker marker2 = markerArray[i2];
            if (marker2.equals(marker)) continue;
            if (n3 == n2 - 1) {
                return false;
            }
            markerArray2[n3++] = marker2;
        }
        this.parents = markerArray2;
        return true;
    }

    @Override
    public Marker setParents(Marker ... markerArray) {
        if (markerArray == null || markerArray.length == 0) {
            this.parents = null;
        } else {
            Marker[] markerArray2 = new Marker[markerArray.length];
            System.arraycopy(markerArray, 0, markerArray2, 0, markerArray.length);
            this.parents = markerArray2;
        }
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Marker[] getParents() {
        if (this.parents == null) {
            return null;
        }
        return Arrays.copyOf(this.parents, this.parents.length);
    }

    @Override
    public boolean hasParents() {
        return this.parents != null;
    }

    @Override
    @PerformanceSensitive(value={"allocation", "unrolled"})
    public boolean isInstanceOf(Marker marker) {
        MarkerManager.access$000(marker, "A marker parameter is required");
        if (this == marker) {
            return true;
        }
        Marker[] markerArray = this.parents;
        if (markerArray != null) {
            int n2 = markerArray.length;
            if (n2 == 1) {
                return MarkerManager$Log4jMarker.checkParent(markerArray[0], marker);
            }
            if (n2 == 2) {
                return MarkerManager$Log4jMarker.checkParent(markerArray[0], marker) || MarkerManager$Log4jMarker.checkParent(markerArray[1], marker);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                Marker marker2 = markerArray[i2];
                if (!MarkerManager$Log4jMarker.checkParent(marker2, marker)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @PerformanceSensitive(value={"allocation", "unrolled"})
    public boolean isInstanceOf(String string) {
        MarkerManager.access$000(string, "A marker name is required");
        if (string.equals(this.getName())) {
            return true;
        }
        Marker marker = (Marker)MarkerManager.access$100().get(string);
        if (marker == null) {
            return false;
        }
        Marker[] markerArray = this.parents;
        if (markerArray != null) {
            int n2 = markerArray.length;
            if (n2 == 1) {
                return MarkerManager$Log4jMarker.checkParent(markerArray[0], marker);
            }
            if (n2 == 2) {
                return MarkerManager$Log4jMarker.checkParent(markerArray[0], marker) || MarkerManager$Log4jMarker.checkParent(markerArray[1], marker);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                Marker marker2 = markerArray[i2];
                if (!MarkerManager$Log4jMarker.checkParent(marker2, marker)) continue;
                return true;
            }
        }
        return false;
    }

    @PerformanceSensitive(value={"allocation", "unrolled"})
    private static boolean checkParent(Marker marker, Marker marker2) {
        Marker[] markerArray;
        if (marker == marker2) {
            return true;
        }
        Marker[] markerArray2 = markerArray = marker instanceof MarkerManager$Log4jMarker ? ((MarkerManager$Log4jMarker)marker).parents : marker.getParents();
        if (markerArray != null) {
            int n2 = markerArray.length;
            if (n2 == 1) {
                return MarkerManager$Log4jMarker.checkParent(markerArray[0], marker2);
            }
            if (n2 == 2) {
                return MarkerManager$Log4jMarker.checkParent(markerArray[0], marker2) || MarkerManager$Log4jMarker.checkParent(markerArray[1], marker2);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                Marker marker3 = markerArray[i2];
                if (!MarkerManager$Log4jMarker.checkParent(marker3, marker2)) continue;
                return true;
            }
        }
        return false;
    }

    @PerformanceSensitive(value={"allocation"})
    private static boolean contains(Marker marker, Marker ... markerArray) {
        for (Marker marker2 : markerArray) {
            if (marker2 != marker) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)object;
        return this.name.equals(marker.getName());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.formatTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.name);
        Marker[] markerArray = this.parents;
        if (markerArray != null) {
            MarkerManager$Log4jMarker.addParentInfo(stringBuilder, markerArray);
        }
    }

    @PerformanceSensitive(value={"allocation"})
    private static void addParentInfo(StringBuilder stringBuilder, Marker ... markerArray) {
        stringBuilder.append("[ ");
        boolean bl2 = true;
        for (Marker marker : markerArray) {
            Marker[] markerArray2;
            if (!bl2) {
                stringBuilder.append(", ");
            }
            bl2 = false;
            stringBuilder.append(marker.getName());
            Marker[] markerArray3 = markerArray2 = marker instanceof MarkerManager$Log4jMarker ? ((MarkerManager$Log4jMarker)marker).parents : marker.getParents();
            if (markerArray2 == null) continue;
            MarkerManager$Log4jMarker.addParentInfo(stringBuilder, markerArray2);
        }
        stringBuilder.append(" ]");
    }
}

