/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Immutable;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.Args;

@Immutable
public class ResponseConnControl
implements HttpResponseInterceptor {
    public void process(HttpResponse httpResponse, HttpContext httpContext) {
        Object object;
        Args.notNull(httpResponse, "HTTP response");
        HttpCoreContext httpCoreContext = HttpCoreContext.adapt(httpContext);
        int n2 = httpResponse.getStatusLine().getStatusCode();
        if (n2 == 400 || n2 == 408 || n2 == 411 || n2 == 413 || n2 == 414 || n2 == 503 || n2 == 501) {
            httpResponse.setHeader("Connection", "Close");
            return;
        }
        Header header = httpResponse.getFirstHeader("Connection");
        if (header != null && "Close".equalsIgnoreCase(header.getValue())) {
            return;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            object = httpResponse.getStatusLine().getProtocolVersion();
            if (httpEntity.getContentLength() < 0L && (!httpEntity.isChunked() || ((ProtocolVersion)object).lessEquals(HttpVersion.HTTP_1_0))) {
                httpResponse.setHeader("Connection", "Close");
                return;
            }
        }
        if ((object = httpCoreContext.getRequest()) != null) {
            Header header2 = object.getFirstHeader("Connection");
            if (header2 != null) {
                httpResponse.setHeader("Connection", header2.getValue());
            } else if (object.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                httpResponse.setHeader("Connection", "Close");
            }
        }
    }
}

