/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestInterceptorList;
import org.apache.http.protocol.HttpResponseInterceptorList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class ImmutableHttpProcessor
implements HttpProcessor {
    private final HttpRequestInterceptor[] requestInterceptors;
    private final HttpResponseInterceptor[] responseInterceptors;

    public ImmutableHttpProcessor(HttpRequestInterceptor[] httpRequestInterceptorArray, HttpResponseInterceptor[] httpResponseInterceptorArray) {
        int n2;
        if (httpRequestInterceptorArray != null) {
            n2 = httpRequestInterceptorArray.length;
            this.requestInterceptors = new HttpRequestInterceptor[n2];
            System.arraycopy(httpRequestInterceptorArray, 0, this.requestInterceptors, 0, n2);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (httpResponseInterceptorArray != null) {
            n2 = httpResponseInterceptorArray.length;
            this.responseInterceptors = new HttpResponseInterceptor[n2];
            System.arraycopy(httpResponseInterceptorArray, 0, this.responseInterceptors, 0, n2);
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(List<HttpRequestInterceptor> list, List<HttpResponseInterceptor> list2) {
        int n2;
        if (list != null) {
            n2 = list.size();
            this.requestInterceptors = list.toArray(new HttpRequestInterceptor[n2]);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (list2 != null) {
            n2 = list2.size();
            this.responseInterceptors = list2.toArray(new HttpResponseInterceptor[n2]);
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    @Deprecated
    public ImmutableHttpProcessor(HttpRequestInterceptorList httpRequestInterceptorList, HttpResponseInterceptorList httpResponseInterceptorList) {
        int n2;
        int n3;
        if (httpRequestInterceptorList != null) {
            n3 = httpRequestInterceptorList.getRequestInterceptorCount();
            this.requestInterceptors = new HttpRequestInterceptor[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.requestInterceptors[n2] = httpRequestInterceptorList.getRequestInterceptor(n2);
            }
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (httpResponseInterceptorList != null) {
            n3 = httpResponseInterceptorList.getResponseInterceptorCount();
            this.responseInterceptors = new HttpResponseInterceptor[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.responseInterceptors[n2] = httpResponseInterceptorList.getResponseInterceptor(n2);
            }
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(HttpRequestInterceptor ... httpRequestInterceptorArray) {
        this(httpRequestInterceptorArray, (HttpResponseInterceptor[])null);
    }

    public ImmutableHttpProcessor(HttpResponseInterceptor ... httpResponseInterceptorArray) {
        this((HttpRequestInterceptor[])null, httpResponseInterceptorArray);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        for (HttpRequestInterceptor httpRequestInterceptor : this.requestInterceptors) {
            httpRequestInterceptor.process(httpRequest, httpContext);
        }
    }

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) {
        for (HttpResponseInterceptor httpResponseInterceptor : this.responseInterceptors) {
            httpResponseInterceptor.process(httpResponse, httpContext);
        }
    }
}

