/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.pool.AbstractConnPool$1;
import org.apache.http.pool.AbstractConnPool$2;
import org.apache.http.pool.AbstractConnPool$3;
import org.apache.http.pool.AbstractConnPool$4;
import org.apache.http.pool.ConnFactory;
import org.apache.http.pool.ConnPool;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.PoolEntryCallback;
import org.apache.http.pool.PoolEntryFuture;
import org.apache.http.pool.PoolStats;
import org.apache.http.pool.RouteSpecificPool;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractConnPool<T, C, E extends PoolEntry<T, C>>
implements ConnPool<T, E>,
ConnPoolControl<T> {
    private final Lock lock;
    private final ConnFactory<T, C> connFactory;
    private final Map<T, RouteSpecificPool<T, C, E>> routeToPool;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final LinkedList<PoolEntryFuture<E>> pending;
    private final Map<T, Integer> maxPerRoute;
    private volatile boolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;

    public AbstractConnPool(ConnFactory<T, C> connFactory, int n2, int n3) {
        this.connFactory = Args.notNull(connFactory, "Connection factory");
        this.defaultMaxPerRoute = Args.notNegative(n2, "Max per route value");
        this.maxTotal = Args.notNegative(n3, "Max total value");
        this.lock = new ReentrantLock();
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, C, E>>();
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.pending = new LinkedList();
        this.maxPerRoute = new HashMap<T, Integer>();
    }

    protected abstract E createEntry(T var1, C var2);

    protected void onLease(E e2) {
    }

    protected void onRelease(E e2) {
    }

    public boolean isShutdown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.isShutDown) {
            return;
        }
        this.isShutDown = true;
        this.lock.lock();
        try {
            for (PoolEntry object : this.available) {
                object.close();
            }
            for (PoolEntry poolEntry : this.leased) {
                poolEntry.close();
            }
            for (RouteSpecificPool routeSpecificPool : this.routeToPool.values()) {
                routeSpecificPool.shutdown();
            }
            this.routeToPool.clear();
            this.leased.clear();
            this.available.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private RouteSpecificPool<T, C, E> getPool(T t2) {
        AbstractConnPool$1 abstractConnPool$1 = this.routeToPool.get(t2);
        if (abstractConnPool$1 == null) {
            abstractConnPool$1 = new AbstractConnPool$1(this, t2, t2);
            this.routeToPool.put(t2, abstractConnPool$1);
        }
        return abstractConnPool$1;
    }

    @Override
    public Future<E> lease(T t2, Object object, FutureCallback<E> futureCallback) {
        Args.notNull(t2, "Route");
        Asserts.check(!this.isShutDown, "Connection pool shut down");
        return new AbstractConnPool$2(this, this.lock, futureCallback, t2, object);
    }

    public Future<E> lease(T t2, Object object) {
        return this.lease(t2, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E getPoolEntryBlocking(T t2, Object object, long l2, TimeUnit timeUnit, PoolEntryFuture<E> poolEntryFuture) {
        Date date = null;
        if (l2 > 0L) {
            date = new Date(System.currentTimeMillis() + timeUnit.toMillis(l2));
        }
        this.lock.lock();
        try {
            RouteSpecificPool routeSpecificPool = this.getPool(t2);
            PoolEntry poolEntry = null;
            while (poolEntry == null) {
                int n2;
                int n3;
                Asserts.check(!this.isShutDown, "Connection pool shut down");
                while ((poolEntry = (PoolEntry)routeSpecificPool.getFree(object)) != null && (poolEntry.isClosed() || poolEntry.isExpired(System.currentTimeMillis()))) {
                    poolEntry.close();
                    this.available.remove(poolEntry);
                    routeSpecificPool.free(poolEntry, false);
                }
                if (poolEntry != null) {
                    this.available.remove(poolEntry);
                    this.leased.add(poolEntry);
                    PoolEntry poolEntry2 = poolEntry;
                    return (E)poolEntry2;
                }
                int n4 = this.getMax(t2);
                int n5 = Math.max(0, routeSpecificPool.getAllocatedCount() + 1 - n4);
                if (n5 > 0) {
                    E e2;
                    for (n3 = 0; n3 < n5 && (e2 = routeSpecificPool.getLastUsed()) != null; ++n3) {
                        ((PoolEntry)e2).close();
                        this.available.remove(e2);
                        routeSpecificPool.remove(e2);
                    }
                }
                if (routeSpecificPool.getAllocatedCount() < n4 && (n2 = Math.max(this.maxTotal - (n3 = this.leased.size()), 0)) > 0) {
                    Object object2;
                    Object object3;
                    int n6 = this.available.size();
                    if (n6 > n2 - 1 && !this.available.isEmpty()) {
                        object3 = (PoolEntry)this.available.removeLast();
                        ((PoolEntry)object3).close();
                        object2 = this.getPool(((PoolEntry)object3).getRoute());
                        ((RouteSpecificPool)object2).remove(object3);
                    }
                    object3 = this.connFactory.create(t2);
                    poolEntry = routeSpecificPool.add(object3);
                    this.leased.add(poolEntry);
                    object2 = poolEntry;
                    return (E)object2;
                }
                n3 = 0;
                try {
                    routeSpecificPool.queue(poolEntryFuture);
                    this.pending.add(poolEntryFuture);
                    n3 = poolEntryFuture.await(date) ? 1 : 0;
                }
                finally {
                    routeSpecificPool.unqueue(poolEntryFuture);
                    this.pending.remove(poolEntryFuture);
                }
                if (n3 != 0 || date == null || date.getTime() > System.currentTimeMillis()) continue;
                break;
            }
            throw new TimeoutException("Timeout waiting for connection");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(E e2, boolean bl2) {
        this.lock.lock();
        try {
            if (this.leased.remove(e2)) {
                RouteSpecificPool routeSpecificPool = this.getPool(((PoolEntry)e2).getRoute());
                routeSpecificPool.free(e2, bl2);
                if (bl2 && !this.isShutDown) {
                    this.available.addFirst(e2);
                    this.onRelease(e2);
                } else {
                    ((PoolEntry)e2).close();
                }
                PoolEntryFuture<E> poolEntryFuture = routeSpecificPool.nextPending();
                if (poolEntryFuture != null) {
                    this.pending.remove(poolEntryFuture);
                } else {
                    poolEntryFuture = this.pending.poll();
                }
                if (poolEntryFuture != null) {
                    poolEntryFuture.wakeup();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getMax(T t2) {
        Integer n2 = this.maxPerRoute.get(t2);
        if (n2 != null) {
            return n2;
        }
        return this.defaultMaxPerRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxTotal(int n2) {
        Args.notNegative(n2, "Max value");
        this.lock.lock();
        try {
            this.maxTotal = n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxTotal() {
        this.lock.lock();
        try {
            int n2 = this.maxTotal;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultMaxPerRoute(int n2) {
        Args.notNegative(n2, "Max per route value");
        this.lock.lock();
        try {
            this.defaultMaxPerRoute = n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultMaxPerRoute() {
        this.lock.lock();
        try {
            int n2 = this.defaultMaxPerRoute;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxPerRoute(T t2, int n2) {
        Args.notNull(t2, "Route");
        Args.notNegative(n2, "Max per route value");
        this.lock.lock();
        try {
            this.maxPerRoute.put(t2, n2);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxPerRoute(T t2) {
        Args.notNull(t2, "Route");
        this.lock.lock();
        try {
            int n2 = this.getMax(t2);
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            PoolStats poolStats = new PoolStats(this.leased.size(), this.pending.size(), this.available.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolStats getStats(T t2) {
        Args.notNull(t2, "Route");
        this.lock.lock();
        try {
            RouteSpecificPool<T, C, E> routeSpecificPool = this.getPool(t2);
            PoolStats poolStats = new PoolStats(routeSpecificPool.getLeasedCount(), routeSpecificPool.getPendingCount(), routeSpecificPool.getAvailableCount(), this.getMax(t2));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumAvailable(PoolEntryCallback<T, C> poolEntryCallback) {
        this.lock.lock();
        try {
            Iterator iterator = this.available.iterator();
            while (iterator.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)iterator.next();
                poolEntryCallback.process(poolEntry);
                if (!poolEntry.isClosed()) continue;
                RouteSpecificPool routeSpecificPool = this.getPool(poolEntry.getRoute());
                routeSpecificPool.remove(poolEntry);
                iterator.remove();
            }
            this.purgePoolMap();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumLeased(PoolEntryCallback<T, C> poolEntryCallback) {
        this.lock.lock();
        try {
            for (PoolEntry poolEntry : this.leased) {
                poolEntryCallback.process(poolEntry);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void purgePoolMap() {
        Iterator<Map.Entry<T, RouteSpecificPool<T, C, E>>> iterator = this.routeToPool.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, RouteSpecificPool<T, C, E>> entry = iterator.next();
            RouteSpecificPool<T, C, E> routeSpecificPool = entry.getValue();
            if (routeSpecificPool.getPendingCount() + routeSpecificPool.getAllocatedCount() != 0) continue;
            iterator.remove();
        }
    }

    public void closeIdle(long l2, TimeUnit timeUnit) {
        Args.notNull(timeUnit, "Time unit");
        long l3 = timeUnit.toMillis(l2);
        if (l3 < 0L) {
            l3 = 0L;
        }
        long l4 = System.currentTimeMillis() - l3;
        this.enumAvailable(new AbstractConnPool$3(this, l4));
    }

    public void closeExpired() {
        long l2 = System.currentTimeMillis();
        this.enumAvailable(new AbstractConnPool$4(this, l2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[leased: ");
        stringBuilder.append(this.leased);
        stringBuilder.append("][available: ");
        stringBuilder.append(this.available);
        stringBuilder.append("][pending: ");
        stringBuilder.append(this.pending);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static /* synthetic */ PoolEntry access$000(AbstractConnPool abstractConnPool, Object object, Object object2, long l2, TimeUnit timeUnit, PoolEntryFuture poolEntryFuture) {
        return abstractConnPool.getPoolEntryBlocking(object, object2, l2, timeUnit, poolEntryFuture);
    }
}

