/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class ParserCursor {
    private final int lowerBound;
    private final int upperBound;
    private int pos;

    public ParserCursor(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Lower bound cannot be negative");
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Lower bound cannot be greater then upper bound");
        }
        this.lowerBound = n2;
        this.upperBound = n3;
        this.pos = n2;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int getPos() {
        return this.pos;
    }

    public void updatePos(int n2) {
        if (n2 < this.lowerBound) {
            throw new IndexOutOfBoundsException("pos: " + n2 + " < lowerBound: " + this.lowerBound);
        }
        if (n2 > this.upperBound) {
            throw new IndexOutOfBoundsException("pos: " + n2 + " > upperBound: " + this.upperBound);
        }
        this.pos = n2;
    }

    public boolean atEnd() {
        return this.pos >= this.upperBound;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(Integer.toString(this.lowerBound));
        stringBuilder.append('>');
        stringBuilder.append(Integer.toString(this.pos));
        stringBuilder.append('>');
        stringBuilder.append(Integer.toString(this.upperBound));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

