/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicLineParser
implements LineParser {
    @Deprecated
    public static final BasicLineParser DEFAULT = new BasicLineParser();
    public static final BasicLineParser INSTANCE = new BasicLineParser();
    protected final ProtocolVersion protocol;

    public BasicLineParser(ProtocolVersion protocolVersion) {
        this.protocol = protocolVersion != null ? protocolVersion : HttpVersion.HTTP_1_1;
    }

    public BasicLineParser() {
        this(null);
    }

    public static ProtocolVersion parseProtocolVersion(String string, LineParser lineParser) {
        Args.notNull(string, "Value");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return (lineParser != null ? lineParser : INSTANCE).parseProtocolVersion(charArrayBuffer, parserCursor);
    }

    public ProtocolVersion parseProtocolVersion(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        int n2;
        int n3;
        int n4;
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        String string = this.protocol.getProtocol();
        int n5 = string.length();
        int n6 = parserCursor.getPos();
        int n7 = parserCursor.getUpperBound();
        this.skipWhitespace(charArrayBuffer, parserCursor);
        int n8 = parserCursor.getPos();
        if (n8 + n5 + 4 > n7) {
            throw new ParseException("Not a valid protocol version: " + charArrayBuffer.substring(n6, n7));
        }
        boolean bl2 = true;
        for (n4 = 0; bl2 && n4 < n5; ++n4) {
            bl2 = charArrayBuffer.charAt(n8 + n4) == string.charAt(n4);
        }
        if (bl2) {
            boolean bl3 = bl2 = charArrayBuffer.charAt(n8 + n5) == '/';
        }
        if (!bl2) {
            throw new ParseException("Not a valid protocol version: " + charArrayBuffer.substring(n6, n7));
        }
        n4 = charArrayBuffer.indexOf(46, n8 += n5 + 1, n7);
        if (n4 == -1) {
            throw new ParseException("Invalid protocol version number: " + charArrayBuffer.substring(n6, n7));
        }
        try {
            n3 = Integer.parseInt(charArrayBuffer.substringTrimmed(n8, n4));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid protocol major version number: " + charArrayBuffer.substring(n6, n7));
        }
        n8 = n4 + 1;
        int n9 = charArrayBuffer.indexOf(32, n8, n7);
        if (n9 == -1) {
            n9 = n7;
        }
        try {
            n2 = Integer.parseInt(charArrayBuffer.substringTrimmed(n8, n9));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid protocol minor version number: " + charArrayBuffer.substring(n6, n7));
        }
        parserCursor.updatePos(n9);
        return this.createProtocolVersion(n3, n2);
    }

    protected ProtocolVersion createProtocolVersion(int n2, int n3) {
        return this.protocol.forVersion(n2, n3);
    }

    public boolean hasProtocolVersion(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        int n2;
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        String string = this.protocol.getProtocol();
        int n3 = string.length();
        if (charArrayBuffer.length() < n3 + 4) {
            return false;
        }
        if (n2 < 0) {
            n2 = charArrayBuffer.length() - 4 - n3;
        } else if (n2 == 0) {
            for (n2 = parserCursor.getPos(); n2 < charArrayBuffer.length() && HTTP.isWhitespace(charArrayBuffer.charAt(n2)); ++n2) {
            }
        }
        if (n2 + n3 + 4 > charArrayBuffer.length()) {
            return false;
        }
        boolean bl2 = true;
        for (int i2 = 0; bl2 && i2 < n3; ++i2) {
            bl2 = charArrayBuffer.charAt(n2 + i2) == string.charAt(i2);
        }
        if (bl2) {
            bl2 = charArrayBuffer.charAt(n2 + n3) == '/';
        }
        return bl2;
    }

    public static RequestLine parseRequestLine(String string, LineParser lineParser) {
        Args.notNull(string, "Value");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return (lineParser != null ? lineParser : INSTANCE).parseRequestLine(charArrayBuffer, parserCursor);
    }

    public RequestLine parseRequestLine(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getUpperBound();
        try {
            this.skipWhitespace(charArrayBuffer, parserCursor);
            int n4 = parserCursor.getPos();
            int n5 = charArrayBuffer.indexOf(32, n4, n3);
            if (n5 < 0) {
                throw new ParseException("Invalid request line: " + charArrayBuffer.substring(n2, n3));
            }
            String string = charArrayBuffer.substringTrimmed(n4, n5);
            parserCursor.updatePos(n5);
            this.skipWhitespace(charArrayBuffer, parserCursor);
            n4 = parserCursor.getPos();
            n5 = charArrayBuffer.indexOf(32, n4, n3);
            if (n5 < 0) {
                throw new ParseException("Invalid request line: " + charArrayBuffer.substring(n2, n3));
            }
            String string2 = charArrayBuffer.substringTrimmed(n4, n5);
            parserCursor.updatePos(n5);
            ProtocolVersion protocolVersion = this.parseProtocolVersion(charArrayBuffer, parserCursor);
            this.skipWhitespace(charArrayBuffer, parserCursor);
            if (!parserCursor.atEnd()) {
                throw new ParseException("Invalid request line: " + charArrayBuffer.substring(n2, n3));
            }
            return this.createRequestLine(string, string2, protocolVersion);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ParseException("Invalid request line: " + charArrayBuffer.substring(n2, n3));
        }
    }

    protected RequestLine createRequestLine(String string, String string2, ProtocolVersion protocolVersion) {
        return new BasicRequestLine(string, string2, protocolVersion);
    }

    public static StatusLine parseStatusLine(String string, LineParser lineParser) {
        Args.notNull(string, "Value");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return (lineParser != null ? lineParser : INSTANCE).parseStatusLine(charArrayBuffer, parserCursor);
    }

    public StatusLine parseStatusLine(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getUpperBound();
        try {
            int n4;
            ProtocolVersion protocolVersion = this.parseProtocolVersion(charArrayBuffer, parserCursor);
            this.skipWhitespace(charArrayBuffer, parserCursor);
            int n5 = parserCursor.getPos();
            int n6 = charArrayBuffer.indexOf(32, n5, n3);
            if (n6 < 0) {
                n6 = n3;
            }
            String string = charArrayBuffer.substringTrimmed(n5, n6);
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (Character.isDigit(string.charAt(i2))) continue;
                throw new ParseException("Status line contains invalid status code: " + charArrayBuffer.substring(n2, n3));
            }
            try {
                n4 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Status line contains invalid status code: " + charArrayBuffer.substring(n2, n3));
            }
            n5 = n6;
            String string2 = n5 < n3 ? charArrayBuffer.substringTrimmed(n5, n3) : "";
            return this.createStatusLine(protocolVersion, n4, string2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ParseException("Invalid status line: " + charArrayBuffer.substring(n2, n3));
        }
    }

    protected StatusLine createStatusLine(ProtocolVersion protocolVersion, int n2, String string) {
        return new BasicStatusLine(protocolVersion, n2, string);
    }

    public static Header parseHeader(String string, LineParser lineParser) {
        Args.notNull(string, "Value");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        return (lineParser != null ? lineParser : INSTANCE).parseHeader(charArrayBuffer);
    }

    public Header parseHeader(CharArrayBuffer charArrayBuffer) {
        return new BufferedHeader(charArrayBuffer);
    }

    protected void skipWhitespace(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        int n2;
        int n3 = parserCursor.getUpperBound();
        for (n2 = parserCursor.getPos(); n2 < n3 && HTTP.isWhitespace(charArrayBuffer.charAt(n2)); ++n2) {
        }
        parserCursor.updatePos(n2);
    }
}

