/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicHeaderValueParser
implements HeaderValueParser {
    @Deprecated
    public static final BasicHeaderValueParser DEFAULT = new BasicHeaderValueParser();
    public static final BasicHeaderValueParser INSTANCE = new BasicHeaderValueParser();
    private static final char PARAM_DELIMITER = ';';
    private static final char ELEM_DELIMITER = ',';
    private static final char[] ALL_DELIMITERS = new char[]{';', ','};

    public static HeaderElement[] parseElements(String string, HeaderValueParser headerValueParser) {
        Args.notNull(string, "Value");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return (headerValueParser != null ? headerValueParser : INSTANCE).parseElements(charArrayBuffer, parserCursor);
    }

    public HeaderElement[] parseElements(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        ArrayList<HeaderElement> arrayList = new ArrayList<HeaderElement>();
        while (!parserCursor.atEnd()) {
            HeaderElement headerElement = this.parseHeaderElement(charArrayBuffer, parserCursor);
            if (headerElement.getName().length() == 0 && headerElement.getValue() == null) continue;
            arrayList.add(headerElement);
        }
        return arrayList.toArray(new HeaderElement[arrayList.size()]);
    }

    public static HeaderElement parseHeaderElement(String string, HeaderValueParser headerValueParser) {
        Args.notNull(string, "Value");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return (headerValueParser != null ? headerValueParser : INSTANCE).parseHeaderElement(charArrayBuffer, parserCursor);
    }

    public HeaderElement parseHeaderElement(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        char c2;
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        NameValuePair nameValuePair = this.parseNameValuePair(charArrayBuffer, parserCursor);
        NameValuePair[] nameValuePairArray = null;
        if (!parserCursor.atEnd() && (c2 = charArrayBuffer.charAt(parserCursor.getPos() - 1)) != ',') {
            nameValuePairArray = this.parseParameters(charArrayBuffer, parserCursor);
        }
        return this.createHeaderElement(nameValuePair.getName(), nameValuePair.getValue(), nameValuePairArray);
    }

    protected HeaderElement createHeaderElement(String string, String string2, NameValuePair[] nameValuePairArray) {
        return new BasicHeaderElement(string, string2, nameValuePairArray);
    }

    public static NameValuePair[] parseParameters(String string, HeaderValueParser headerValueParser) {
        Args.notNull(string, "Value");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return (headerValueParser != null ? headerValueParser : INSTANCE).parseParameters(charArrayBuffer, parserCursor);
    }

    public NameValuePair[] parseParameters(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        char c2;
        int n2;
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        int n3 = parserCursor.getUpperBound();
        for (n2 = parserCursor.getPos(); n2 < n3 && HTTP.isWhitespace(c2 = charArrayBuffer.charAt(n2)); ++n2) {
        }
        parserCursor.updatePos(n2);
        if (parserCursor.atEnd()) {
            return new NameValuePair[0];
        }
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        while (!parserCursor.atEnd()) {
            NameValuePair nameValuePair = this.parseNameValuePair(charArrayBuffer, parserCursor);
            arrayList.add(nameValuePair);
            char c3 = charArrayBuffer.charAt(parserCursor.getPos() - 1);
            if (c3 != ',') continue;
            break;
        }
        return arrayList.toArray(new NameValuePair[arrayList.size()]);
    }

    public static NameValuePair parseNameValuePair(String string, HeaderValueParser headerValueParser) {
        Args.notNull(string, "Value");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        return (headerValueParser != null ? headerValueParser : INSTANCE).parseNameValuePair(charArrayBuffer, parserCursor);
    }

    public NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        return this.parseNameValuePair(charArrayBuffer, parserCursor, ALL_DELIMITERS);
    }

    private static boolean isOneOf(char c2, char[] cArray) {
        if (cArray != null) {
            for (char c3 : cArray) {
                if (c2 != c3) continue;
                return true;
            }
        }
        return false;
    }

    public NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, char[] cArray) {
        int n2;
        String string;
        char c2;
        int n3;
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        boolean bl2 = false;
        int n4 = parserCursor.getPos();
        int n5 = parserCursor.getUpperBound();
        for (n3 = parserCursor.getPos(); n3 < n5 && (c2 = charArrayBuffer.charAt(n3)) != '='; ++n3) {
            if (!BasicHeaderValueParser.isOneOf(c2, cArray)) continue;
            bl2 = true;
            break;
        }
        if (n3 == n5) {
            bl2 = true;
            string = charArrayBuffer.substringTrimmed(n4, n5);
        } else {
            string = charArrayBuffer.substringTrimmed(n4, n3);
            ++n3;
        }
        if (bl2) {
            parserCursor.updatePos(n3);
            return this.createNameValuePair(string, null);
        }
        int n6 = n3;
        boolean bl3 = false;
        boolean bl4 = false;
        while (n3 < n5) {
            n2 = charArrayBuffer.charAt(n3);
            if (n2 == 34 && !bl4) {
                boolean bl5 = bl3 = !bl3;
            }
            if (!bl3 && !bl4 && BasicHeaderValueParser.isOneOf((char)n2, cArray)) {
                bl2 = true;
                break;
            }
            bl4 = bl4 ? false : bl3 && n2 == 92;
            ++n3;
        }
        n2 = n3;
        while (n6 < n2 && HTTP.isWhitespace(charArrayBuffer.charAt(n6))) {
            ++n6;
        }
        while (n2 > n6 && HTTP.isWhitespace(charArrayBuffer.charAt(n2 - 1))) {
            --n2;
        }
        if (n2 - n6 >= 2 && charArrayBuffer.charAt(n6) == '\"' && charArrayBuffer.charAt(n2 - 1) == '\"') {
            ++n6;
            --n2;
        }
        String string2 = charArrayBuffer.substring(n6, n2);
        if (bl2) {
            ++n3;
        }
        parserCursor.updatePos(n3);
        return this.createNameValuePair(string, string2);
    }

    protected NameValuePair createNameValuePair(String string, String string2) {
        return new BasicNameValuePair(string, string2);
    }
}

