/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class SessionOutputBufferImpl
implements BufferInfo,
SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final HttpTransportMetricsImpl metrics;
    private final ByteArrayBuffer buffer;
    private final int fragementSizeHint;
    private final CharsetEncoder encoder;
    private OutputStream outstream;
    private ByteBuffer bbuf;

    public SessionOutputBufferImpl(HttpTransportMetricsImpl httpTransportMetricsImpl, int n2, int n3, CharsetEncoder charsetEncoder) {
        Args.positive(n2, "Buffer size");
        Args.notNull(httpTransportMetricsImpl, "HTTP transport metrcis");
        this.metrics = httpTransportMetricsImpl;
        this.buffer = new ByteArrayBuffer(n2);
        this.fragementSizeHint = n3 >= 0 ? n3 : 0;
        this.encoder = charsetEncoder;
    }

    public SessionOutputBufferImpl(HttpTransportMetricsImpl httpTransportMetricsImpl, int n2) {
        this(httpTransportMetricsImpl, n2, n2, null);
    }

    public void bind(OutputStream outputStream) {
        this.outstream = outputStream;
    }

    public boolean isBound() {
        return this.outstream != null;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int length() {
        return this.buffer.length();
    }

    public int available() {
        return this.capacity() - this.length();
    }

    private void streamWrite(byte[] byArray, int n2, int n3) {
        Asserts.notNull(this.outstream, "Output stream");
        this.outstream.write(byArray, n2, n3);
    }

    private void flushStream() {
        if (this.outstream != null) {
            this.outstream.flush();
        }
    }

    private void flushBuffer() {
        int n2 = this.buffer.length();
        if (n2 > 0) {
            this.streamWrite(this.buffer.buffer(), 0, n2);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(n2);
        }
    }

    public void flush() {
        this.flushBuffer();
        this.flushStream();
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        if (n3 > this.fragementSizeHint || n3 > this.buffer.capacity()) {
            this.flushBuffer();
            this.streamWrite(byArray, n2, n3);
            this.metrics.incrementBytesTransferred(n3);
        } else {
            int n4 = this.buffer.capacity() - this.buffer.length();
            if (n3 > n4) {
                this.flushBuffer();
            }
            this.buffer.append(byArray, n2, n3);
        }
    }

    public void write(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n2) {
        if (this.fragementSizeHint > 0) {
            if (this.buffer.isFull()) {
                this.flushBuffer();
            }
            this.buffer.append(n2);
        } else {
            this.flushBuffer();
            this.outstream.write(n2);
        }
    }

    public void writeLine(String string) {
        if (string == null) {
            return;
        }
        if (string.length() > 0) {
            if (this.encoder == null) {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    this.write(string.charAt(i2));
                }
            } else {
                CharBuffer charBuffer = CharBuffer.wrap(string);
                this.writeEncoded(charBuffer);
            }
        }
        this.write(CRLF);
    }

    public void writeLine(CharArrayBuffer charArrayBuffer) {
        if (charArrayBuffer == null) {
            return;
        }
        if (this.encoder == null) {
            int n2;
            int n3 = 0;
            for (int i2 = charArrayBuffer.length(); i2 > 0; i2 -= n2) {
                n2 = this.buffer.capacity() - this.buffer.length();
                if ((n2 = Math.min(n2, i2)) > 0) {
                    this.buffer.append(charArrayBuffer, n3, n2);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                n3 += n2;
            }
        } else {
            CharBuffer charBuffer = CharBuffer.wrap(charArrayBuffer.buffer(), 0, charArrayBuffer.length());
            this.writeEncoded(charBuffer);
        }
        this.write(CRLF);
    }

    private void writeEncoded(CharBuffer charBuffer) {
        CoderResult coderResult;
        if (!charBuffer.hasRemaining()) {
            return;
        }
        if (this.bbuf == null) {
            this.bbuf = ByteBuffer.allocate(1024);
        }
        this.encoder.reset();
        while (charBuffer.hasRemaining()) {
            coderResult = this.encoder.encode(charBuffer, this.bbuf, true);
            this.handleEncodingResult(coderResult);
        }
        coderResult = this.encoder.flush(this.bbuf);
        this.handleEncodingResult(coderResult);
        this.bbuf.clear();
    }

    private void handleEncodingResult(CoderResult coderResult) {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.bbuf.flip();
        while (this.bbuf.hasRemaining()) {
            this.write(this.bbuf.get());
        }
        this.bbuf.compact();
    }

    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

