/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.apache.http.MessageConstraintException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class SessionInputBufferImpl
implements BufferInfo,
SessionInputBuffer {
    private final HttpTransportMetricsImpl metrics;
    private final byte[] buffer;
    private final ByteArrayBuffer linebuffer;
    private final int minChunkLimit;
    private final MessageConstraints constraints;
    private final CharsetDecoder decoder;
    private InputStream instream;
    private int bufferpos;
    private int bufferlen;
    private CharBuffer cbuf;

    public SessionInputBufferImpl(HttpTransportMetricsImpl httpTransportMetricsImpl, int n2, int n3, MessageConstraints messageConstraints, CharsetDecoder charsetDecoder) {
        Args.notNull(httpTransportMetricsImpl, "HTTP transport metrcis");
        Args.positive(n2, "Buffer size");
        this.metrics = httpTransportMetricsImpl;
        this.buffer = new byte[n2];
        this.bufferpos = 0;
        this.bufferlen = 0;
        this.minChunkLimit = n3 >= 0 ? n3 : 512;
        this.constraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.linebuffer = new ByteArrayBuffer(n2);
        this.decoder = charsetDecoder;
    }

    public SessionInputBufferImpl(HttpTransportMetricsImpl httpTransportMetricsImpl, int n2) {
        this(httpTransportMetricsImpl, n2, n2, null, null);
    }

    public void bind(InputStream inputStream) {
        this.instream = inputStream;
    }

    public boolean isBound() {
        return this.instream != null;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.bufferlen - this.bufferpos;
    }

    public int available() {
        return this.capacity() - this.length();
    }

    private int streamRead(byte[] byArray, int n2, int n3) {
        Asserts.notNull(this.instream, "Input stream");
        return this.instream.read(byArray, n2, n3);
    }

    public int fillBuffer() {
        int n2;
        int n3;
        int n4;
        if (this.bufferpos > 0) {
            n4 = this.bufferlen - this.bufferpos;
            if (n4 > 0) {
                System.arraycopy(this.buffer, this.bufferpos, this.buffer, 0, n4);
            }
            this.bufferpos = 0;
            this.bufferlen = n4;
        }
        if ((n4 = this.streamRead(this.buffer, n3 = this.bufferlen, n2 = this.buffer.length - n3)) == -1) {
            return -1;
        }
        this.bufferlen = n3 + n4;
        this.metrics.incrementBytesTransferred(n4);
        return n4;
    }

    public boolean hasBufferedData() {
        return this.bufferpos < this.bufferlen;
    }

    public void clear() {
        this.bufferpos = 0;
        this.bufferlen = 0;
    }

    public int read() {
        while (!this.hasBufferedData()) {
            int n2 = this.fillBuffer();
            if (n2 != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferpos++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null) {
            return 0;
        }
        if (this.hasBufferedData()) {
            int n5 = Math.min(n3, this.bufferlen - this.bufferpos);
            System.arraycopy(this.buffer, this.bufferpos, byArray, n2, n5);
            this.bufferpos += n5;
            return n5;
        }
        if (n3 > this.minChunkLimit) {
            int n6 = this.streamRead(byArray, n2, n3);
            if (n6 > 0) {
                this.metrics.incrementBytesTransferred(n6);
            }
            return n6;
        }
        while (!this.hasBufferedData()) {
            n4 = this.fillBuffer();
            if (n4 != -1) continue;
            return -1;
        }
        n4 = Math.min(n3, this.bufferlen - this.bufferpos);
        System.arraycopy(this.buffer, this.bufferpos, byArray, n2, n4);
        this.bufferpos += n4;
        return n4;
    }

    public int read(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    private int locateLF() {
        for (int i2 = this.bufferpos; i2 < this.bufferlen; ++i2) {
            if (this.buffer[i2] != 10) continue;
            return i2;
        }
        return -1;
    }

    public int readLine(CharArrayBuffer charArrayBuffer) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        int n2 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n3;
            int n4 = this.locateLF();
            if (n4 != -1) {
                if (this.linebuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charArrayBuffer, n4);
                }
                bl2 = false;
                n3 = n4 + 1 - this.bufferpos;
                this.linebuffer.append(this.buffer, this.bufferpos, n3);
                this.bufferpos = n4 + 1;
            } else {
                if (this.hasBufferedData()) {
                    n3 = this.bufferlen - this.bufferpos;
                    this.linebuffer.append(this.buffer, this.bufferpos, n3);
                    this.bufferpos = this.bufferlen;
                }
                if ((n2 = this.fillBuffer()) == -1) {
                    bl2 = false;
                }
            }
            if ((n3 = this.constraints.getMaxLineLength()) <= 0 || this.linebuffer.length() < n3) continue;
            throw new MessageConstraintException("Maximum line length limit exceeded");
        }
        if (n2 == -1 && this.linebuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer(charArrayBuffer);
    }

    private int lineFromLineBuffer(CharArrayBuffer charArrayBuffer) {
        int n2 = this.linebuffer.length();
        if (n2 > 0) {
            if (this.linebuffer.byteAt(n2 - 1) == 10) {
                --n2;
            }
            if (n2 > 0 && this.linebuffer.byteAt(n2 - 1) == 13) {
                --n2;
            }
        }
        if (this.decoder == null) {
            charArrayBuffer.append(this.linebuffer, 0, n2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.linebuffer.buffer(), 0, n2);
            n2 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        this.linebuffer.clear();
        return n2;
    }

    private int lineFromReadBuffer(CharArrayBuffer charArrayBuffer, int n2) {
        int n3 = n2;
        int n4 = this.bufferpos;
        this.bufferpos = n3 + 1;
        if (n3 > n4 && this.buffer[n3 - 1] == 13) {
            --n3;
        }
        int n5 = n3 - n4;
        if (this.decoder == null) {
            charArrayBuffer.append(this.buffer, n4, n5);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer, n4, n5);
            n5 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        return n5;
    }

    private int appendDecoded(CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        if (!byteBuffer.hasRemaining()) {
            return 0;
        }
        if (this.cbuf == null) {
            this.cbuf = CharBuffer.allocate(1024);
        }
        this.decoder.reset();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            coderResult = this.decoder.decode(byteBuffer, this.cbuf, true);
            n2 += this.handleDecodingResult(coderResult, charArrayBuffer, byteBuffer);
        }
        coderResult = this.decoder.flush(this.cbuf);
        this.cbuf.clear();
        return n2 += this.handleDecodingResult(coderResult, charArrayBuffer, byteBuffer);
    }

    private int handleDecodingResult(CoderResult coderResult, CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.cbuf.flip();
        int n2 = this.cbuf.remaining();
        while (this.cbuf.hasRemaining()) {
            charArrayBuffer.append(this.cbuf.get());
        }
        this.cbuf.compact();
        return n2;
    }

    public String readLine() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        int n2 = this.readLine(charArrayBuffer);
        if (n2 != -1) {
            return charArrayBuffer.toString();
        }
        return null;
    }

    public boolean isDataAvailable(int n2) {
        return this.hasBufferedData();
    }

    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

