/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.util.Args;

@NotThreadSafe
public class IdentityOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private boolean closed = false;

    public IdentityOutputStream(SessionOutputBuffer sessionOutputBuffer) {
        this.out = Args.notNull(sessionOutputBuffer, "Session output buffer");
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.out.flush();
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.out.write(byArray, n2, n3);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n2) {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.out.write(n2);
    }
}

