/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.InputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.io.BufferInfo;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.Args;

@NotThreadSafe
public class IdentityInputStream
extends InputStream {
    private final SessionInputBuffer in;
    private boolean closed = false;

    public IdentityInputStream(SessionInputBuffer sessionInputBuffer) {
        this.in = Args.notNull(sessionInputBuffer, "Session input buffer");
    }

    public int available() {
        if (this.in instanceof BufferInfo) {
            return ((BufferInfo)((Object)this.in)).length();
        }
        return 0;
    }

    public void close() {
        this.closed = true;
    }

    public int read() {
        if (this.closed) {
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.closed) {
            return -1;
        }
        return this.in.read(byArray, n2, n3);
    }
}

