/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();

    public HeaderElement parseHeader(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        NameValuePair nameValuePair = this.parseNameValuePair(charArrayBuffer, parserCursor);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        while (!parserCursor.atEnd()) {
            NameValuePair nameValuePair2 = this.parseNameValuePair(charArrayBuffer, parserCursor);
            arrayList.add(nameValuePair2);
        }
        return new BasicHeaderElement(nameValuePair.getName(), nameValuePair.getValue(), arrayList.toArray(new NameValuePair[arrayList.size()]));
    }

    private NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        int n2;
        char c2;
        int n3;
        boolean bl2 = false;
        int n4 = parserCursor.getPos();
        int n5 = parserCursor.getUpperBound();
        String string = null;
        for (n3 = parserCursor.getPos(); n3 < n5 && (c2 = charArrayBuffer.charAt(n3)) != '='; ++n3) {
            if (c2 != ';') continue;
            bl2 = true;
            break;
        }
        if (n3 == n5) {
            bl2 = true;
            string = charArrayBuffer.substringTrimmed(n4, n5);
        } else {
            string = charArrayBuffer.substringTrimmed(n4, n3);
            ++n3;
        }
        if (bl2) {
            parserCursor.updatePos(n3);
            return new BasicNameValuePair(string, null);
        }
        String string2 = null;
        int n6 = n3;
        while (n3 < n5) {
            n2 = charArrayBuffer.charAt(n3);
            if (n2 == 59) {
                bl2 = true;
                break;
            }
            ++n3;
        }
        n2 = n3;
        while (n6 < n2 && HTTP.isWhitespace(charArrayBuffer.charAt(n6))) {
            ++n6;
        }
        while (n2 > n6 && HTTP.isWhitespace(charArrayBuffer.charAt(n2 - 1))) {
            --n2;
        }
        string2 = charArrayBuffer.substring(n6, n2);
        if (bl2) {
            ++n3;
        }
        parserCursor.updatePos(n3);
        return new BasicNameValuePair(string, string2);
    }
}

