/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.conn.Wire;

@NotThreadSafe
class LoggingInputStream
extends InputStream {
    private final InputStream in;
    private final Wire wire;

    public LoggingInputStream(InputStream inputStream, Wire wire) {
        this.in = inputStream;
        this.wire = wire;
    }

    public int read() {
        try {
            int n2 = this.in.read();
            if (n2 == -1) {
                this.wire.input("end of stream");
            } else {
                this.wire.input(n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    public int read(byte[] byArray) {
        try {
            int n2 = this.in.read(byArray);
            if (n2 == -1) {
                this.wire.input("end of stream");
            } else if (n2 > 0) {
                this.wire.input(byArray, 0, n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    public int read(byte[] byArray, int n2, int n3) {
        try {
            int n4 = this.in.read(byArray, n2, n3);
            if (n4 == -1) {
                this.wire.input("end of stream");
            } else if (n4 > 0) {
                this.wire.input(byArray, n2, n4);
            }
            return n4;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    public long skip(long l2) {
        try {
            return super.skip(l2);
        }
        catch (IOException iOException) {
            this.wire.input("[skip] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    public int available() {
        try {
            return this.in.available();
        }
        catch (IOException iOException) {
            this.wire.input("[available] I/O error : " + iOException.getMessage());
            throw iOException;
        }
    }

    public void mark(int n2) {
        super.mark(n2);
    }

    public void reset() {
        super.reset();
    }

    public boolean markSupported() {
        return false;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            this.wire.input("[close] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }
}

